/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core.matcher;

import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.core.matcher.NamedComponentMatcherTemplate;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class JLabelMatcher
extends NamedComponentMatcherTemplate<JLabel> {
    private Object text;

    @Nonnull
    public static JLabelMatcher withName(@Nullable String name) {
        return new JLabelMatcher(name, JLabelMatcher.anyValue());
    }

    @Nonnull
    public static JLabelMatcher withText(@Nullable String text) {
        return new JLabelMatcher(JLabelMatcher.anyValue(), (Object)text);
    }

    @Nonnull
    public static JLabelMatcher withText(@Nonnull Pattern textPattern) {
        return new JLabelMatcher(JLabelMatcher.anyValue(), (Object)textPattern);
    }

    @Nonnull
    public static JLabelMatcher any() {
        return new JLabelMatcher(JLabelMatcher.anyValue(), JLabelMatcher.anyValue());
    }

    private JLabelMatcher(@Nullable Object name, @Nullable Object text) {
        super(JLabel.class, name);
        this.text = text;
    }

    @Nonnull
    public JLabelMatcher andText(@Nullable String newText) {
        this.text = newText;
        return this;
    }

    @Nonnull
    public JLabelMatcher andText(@Nonnull Pattern textPattern) {
        this.text = textPattern;
        return this;
    }

    public JLabelMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(@Nonnull JLabel label) {
        return this.isNameMatching(label.getName()) && this.arePropertyValuesMatching(this.text, label.getText());
    }

    public String toString() {
        String format = "%s[name=%s, text=%s, requireShowing=%b]";
        return String.format(format, this.getClass().getName(), this.quotedName(), this.quoted(this.text), this.requireShowing());
    }
}

