/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.internal.statistic.eventLog.validator.storage.persistence.BaseEventLogMetadataPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventLogMetadataSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.storage.persistence.EventsSchemePathSettings;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogMetadataPersistence
extends BaseEventLogMetadataPersistence {
    private static final String DEPRECATED_EVENTS_SCHEME_FILE = "white-list.json";
    public static final String EVENTS_SCHEME_FILE = "events-scheme.json";
    private static final Logger LOG = Logger.getInstance(EventLogMetadataPersistence.class);
    @NotNull
    private final String myRecorderId;

    public EventLogMetadataPersistence(@NotNull String recorderId) {
        if (recorderId == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(0);
        }
        this.myRecorderId = recorderId;
    }

    @Override
    @Nullable
    public String getCachedEventsScheme() {
        try {
            Path file = this.getEventsSchemeFile();
            if (Files.exists(file, new LinkOption[0]) && Files.isRegularFile(file, new LinkOption[0])) {
                return Files.readString(file);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return null;
    }

    @NotNull
    private Path getEventsSchemeFile() throws IOException {
        EventsSchemePathSettings settings = EventLogMetadataSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        if (settings != null && settings.isUseCustomPath()) {
            Path path = Path.of(settings.getCustomPath(), new String[0]);
            if (path == null) {
                EventLogMetadataPersistence.$$$reportNull$$$0(1);
            }
            return path;
        }
        Path path = this.getDefaultFile();
        if (path == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(2);
        }
        return path;
    }

    @NotNull
    public Path getDefaultFile() throws IOException {
        Path path = EventLogMetadataPersistence.getDefaultMetadataFile(this.myRecorderId, EVENTS_SCHEME_FILE, DEPRECATED_EVENTS_SCHEME_FILE);
        if (path == null) {
            EventLogMetadataPersistence.$$$reportNull$$$0(3);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/EventLogMetadataPersistence";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventsSchemeFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

