/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.internal.WebSocketNegotiation;

public class RFC6455Negotiation
extends WebSocketNegotiation {
    private boolean successful;
    private String key;

    public RFC6455Negotiation(Request request, Response response, Callback callback, WebSocketComponents components) throws HttpException.RuntimeException {
        super(request, response, callback, components);
    }

    @Override
    protected void negotiateHeaders(Request baseRequest) {
        super.negotiateHeaders(baseRequest);
        boolean upgrade = false;
        QuotedCSV connectionCSVs = null;
        for (HttpField field : baseRequest.getHeaders()) {
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case UPGRADE: {
                    upgrade = "websocket".equalsIgnoreCase(field.getValue());
                    break;
                }
                case CONNECTION: {
                    if (connectionCSVs == null) {
                        connectionCSVs = new QuotedCSV(new String[0]);
                    }
                    connectionCSVs.addValue(field.getValue());
                    break;
                }
                case SEC_WEBSOCKET_KEY: {
                    this.key = field.getValue();
                    break;
                }
            }
        }
        this.successful = upgrade && connectionCSVs != null && connectionCSVs.getValues().stream().anyMatch(s -> s.equalsIgnoreCase("upgrade"));
    }

    @Override
    public boolean validateHeaders() {
        return this.successful;
    }

    public String getKey() {
        return this.key;
    }
}

