/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;

public class CharacterDelimiterFrameDecoder
extends DelimiterBasedFrameDecoder {
    private static ByteBuf createDelimiter(char delimiter) {
        byte[] buf = new byte[]{(byte)delimiter};
        return Unpooled.wrappedBuffer((byte[])buf);
    }

    private static ByteBuf createDelimiter(String delimiter) {
        byte[] buf = new byte[delimiter.length()];
        for (int i = 0; i < delimiter.length(); ++i) {
            buf[i] = (byte)delimiter.charAt(i);
        }
        return Unpooled.wrappedBuffer((byte[])buf);
    }

    private static ByteBuf[] convertDelimiters(String[] delimiters) {
        ByteBuf[] result = new ByteBuf[delimiters.length];
        for (int i = 0; i < delimiters.length; ++i) {
            result[i] = CharacterDelimiterFrameDecoder.createDelimiter(delimiters[i]);
        }
        return result;
    }

    public CharacterDelimiterFrameDecoder(int maxFrameLength, char delimiter) {
        super(maxFrameLength, CharacterDelimiterFrameDecoder.createDelimiter(delimiter));
    }

    public CharacterDelimiterFrameDecoder(int maxFrameLength, String delimiter) {
        super(maxFrameLength, CharacterDelimiterFrameDecoder.createDelimiter(delimiter));
    }

    public CharacterDelimiterFrameDecoder(int maxFrameLength, boolean stripDelimiter, String delimiter) {
        super(maxFrameLength, stripDelimiter, CharacterDelimiterFrameDecoder.createDelimiter(delimiter));
    }

    public CharacterDelimiterFrameDecoder(int maxFrameLength, String ... delimiters) {
        super(maxFrameLength, CharacterDelimiterFrameDecoder.convertDelimiters(delimiters));
    }

    public CharacterDelimiterFrameDecoder(int maxFrameLength, boolean stripDelimiter, String ... delimiters) {
        super(maxFrameLength, stripDelimiter, CharacterDelimiterFrameDecoder.convertDelimiters(delimiters));
    }
}

