/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.geocoder;

import jakarta.json.JsonObject;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.InvocationCallback;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.database.StatisticsManager;
import org.traccar.geocoder.Address;
import org.traccar.geocoder.AddressFormat;
import org.traccar.geocoder.Geocoder;
import org.traccar.geocoder.GeocoderException;

public abstract class JsonGeocoder
implements Geocoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonGeocoder.class);
    private final Client client;
    private final String url;
    private final AddressFormat addressFormat;
    private StatisticsManager statisticsManager;
    private Map<Map.Entry<Double, Double>, String> cache;

    public JsonGeocoder(Client client, String url, final int cacheSize, AddressFormat addressFormat) {
        this.client = client;
        this.url = url;
        this.addressFormat = addressFormat;
        if (cacheSize > 0) {
            this.cache = Collections.synchronizedMap(new LinkedHashMap<Map.Entry<Double, Double>, String>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry eldest) {
                    return this.size() > cacheSize;
                }
            });
        }
    }

    @Override
    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    protected String readValue(JsonObject object, String key) {
        if (object.containsKey((Object)key) && !object.isNull(key)) {
            return object.getString(key);
        }
        return null;
    }

    private String handleResponse(double latitude, double longitude, JsonObject json, Geocoder.ReverseGeocoderCallback callback) {
        Address address = this.parseAddress(json);
        if (address != null) {
            String formattedAddress = this.addressFormat.format(address);
            if (this.cache != null) {
                this.cache.put(new AbstractMap.SimpleImmutableEntry<Double, Double>(latitude, longitude), formattedAddress);
            }
            if (callback != null) {
                callback.onSuccess(formattedAddress);
            }
            return formattedAddress;
        }
        String msg = "Empty address. Error: " + this.parseError(json);
        if (callback != null) {
            callback.onFailure(new GeocoderException(msg));
        } else {
            LOGGER.warn(msg);
        }
        return null;
    }

    @Override
    public String getAddress(final double latitude, final double longitude, final Geocoder.ReverseGeocoderCallback callback) {
        String cachedAddress;
        if (this.cache != null && (cachedAddress = this.cache.get(new AbstractMap.SimpleImmutableEntry<Double, Double>(latitude, longitude))) != null) {
            if (callback != null) {
                callback.onSuccess(cachedAddress);
            }
            return cachedAddress;
        }
        if (this.statisticsManager != null) {
            this.statisticsManager.registerGeocoderRequest();
        }
        Invocation.Builder request = this.client.target(String.format(this.url, latitude, longitude)).request();
        if (callback != null) {
            request.async().get((InvocationCallback)new InvocationCallback<JsonObject>(){

                public void completed(JsonObject json) {
                    JsonGeocoder.this.handleResponse(latitude, longitude, json, callback);
                }

                public void failed(Throwable throwable) {
                    callback.onFailure(throwable);
                }
            });
        } else {
            try {
                return this.handleResponse(latitude, longitude, (JsonObject)request.get(JsonObject.class), null);
            }
            catch (Exception e) {
                LOGGER.warn("Geocoder network error", (Throwable)e);
            }
        }
        return null;
    }

    public abstract Address parseAddress(JsonObject var1);

    protected String parseError(JsonObject json) {
        return null;
    }
}

