/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.pipeline.stages;

import com.google.api.core.InternalApi;
import com.google.cloud.firestore.PipelineUtils;
import com.google.cloud.firestore.pipeline.stages.RawOptions;
import com.google.cloud.firestore.pipeline.stages.Stage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.firestore.v1.Value;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public final class RawStage
extends Stage {
    private final List<Object> arguments;

    private RawStage(@Nonnull String name, @Nonnull List<Object> arguments, @Nonnull RawOptions options) {
        super(name, options.options);
        this.arguments = arguments;
    }

    @Nonnull
    public static RawStage ofName(@Nonnull String name) {
        return new RawStage(name, (List<Object>)ImmutableList.of(), new RawOptions());
    }

    @Nonnull
    public RawStage withArguments(Object ... arguments) {
        return new RawStage(this.name, Arrays.asList(arguments), new RawOptions(this.options));
    }

    @Nonnull
    public RawStage withOptions(@Nonnull RawOptions options) {
        return new RawStage(this.name, this.arguments, options);
    }

    @Override
    @InternalApi
    Iterable<Value> toStageArgs() {
        return Iterables.transform(this.arguments, PipelineUtils::encodeValue);
    }
}

