/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.memory;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.results.CCTNode;
import org.graalvm.visualvm.lib.jfluid.results.cpu.PrestimeCPUCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.memory.AllocMemoryResultsDiff;
import org.graalvm.visualvm.lib.jfluid.results.memory.AllocMemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryCCTManager;
import org.graalvm.visualvm.lib.jfluid.results.memory.MemoryResultsSnapshot;
import org.graalvm.visualvm.lib.jfluid.results.memory.PresoObjAllocCCTNode;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.Formatters;
import org.graalvm.visualvm.lib.ui.memory.MemoryJavaNameRenderer;
import org.graalvm.visualvm.lib.ui.memory.MemoryView;
import org.graalvm.visualvm.lib.ui.swing.ExportUtils;
import org.graalvm.visualvm.lib.ui.swing.PopupButton;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTreeTableModel;
import org.graalvm.visualvm.lib.ui.swing.SearchUtils;
import org.graalvm.visualvm.lib.ui.swing.renderer.CheckBoxRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.HideableBarRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.NumberPercentRenderer;

abstract class AllocTreeTableView
extends MemoryView {
    private AllocTreeTableModel treeTableModel;
    private ProfilerTreeTable treeTable;
    private Map<TreeNode, ClientUtils.SourceCodeSelection> nodesMap;
    private final Set<ClientUtils.SourceCodeSelection> selection;
    private boolean filterObjects = true;
    private boolean filterAllocations = false;
    private boolean searchObjects = true;
    private boolean searchAllocations = false;
    private HideableBarRenderer[] renderers;

    AllocTreeTableView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.selection = selection;
        this.initUI();
    }

    @Override
    protected RowFilter getExcludesFilter() {
        return new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)entry.getIdentifier();
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return true;
                }
                if (parent.getParent() == null) {
                    return !AllocTreeTableView.this.filterObjects;
                }
                return !AllocTreeTableView.this.filterAllocations;
            }
        };
    }

    @Override
    protected Component[] getFilterOptions() {
        PopupButton pb = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(MemoryView.FILTER_CLASSES_SCOPE, AllocTreeTableView.this.filterObjects){
                    {
                        if (!AllocTreeTableView.this.filterAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        AllocTreeTableView.this.filterObjects = !AllocTreeTableView.this.filterObjects;
                        AllocTreeTableView.this.enableFilter();
                    }
                });
                popup.add(new JCheckBoxMenuItem(MemoryView.FILTER_ALLOCATIONS_SCOPE, AllocTreeTableView.this.filterAllocations){
                    {
                        if (!AllocTreeTableView.this.filterObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        AllocTreeTableView.this.filterAllocations = !AllocTreeTableView.this.filterAllocations;
                        AllocTreeTableView.this.enableFilter();
                    }
                });
            }
        };
        pb.setToolTipText(FILTER_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), pb};
    }

    @Override
    protected SearchUtils.TreeHelper getSearchHelper() {
        return new SearchUtils.TreeHelper(){

            @Override
            public int getNodeType(TreeNode tnode) {
                PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)tnode;
                CCTNode parent = node.getParent();
                if (parent == null) {
                    return 100;
                }
                if (parent.getParent() == null) {
                    if (AllocTreeTableView.this.searchObjects) {
                        return AllocTreeTableView.this.searchAllocations ? 10 : 11;
                    }
                    return AllocTreeTableView.this.searchAllocations ? 100 : 101;
                }
                return AllocTreeTableView.this.searchAllocations ? 10 : 101;
            }
        };
    }

    @Override
    protected Component[] getSearchOptions() {
        PopupButton pb = new PopupButton(Icons.getIcon((String)"ProfilerIcons.TabCallTree")){

            @Override
            protected void populatePopup(JPopupMenu popup) {
                popup.add(new JCheckBoxMenuItem(MemoryView.SEARCH_CLASSES_SCOPE, AllocTreeTableView.this.searchObjects){
                    {
                        if (!AllocTreeTableView.this.searchAllocations) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        AllocTreeTableView.this.searchObjects = !AllocTreeTableView.this.searchObjects;
                    }
                });
                popup.add(new JCheckBoxMenuItem(MemoryView.SEARCH_ALLOCATIONS_SCOPE, AllocTreeTableView.this.searchAllocations){
                    {
                        if (!AllocTreeTableView.this.searchObjects) {
                            this.setEnabled(false);
                        }
                    }

                    @Override
                    protected void fireActionPerformed(ActionEvent e) {
                        super.fireActionPerformed(e);
                        AllocTreeTableView.this.searchAllocations = !AllocTreeTableView.this.searchAllocations;
                    }
                });
            }
        };
        pb.setToolTipText(SEARCH_SCOPE_TOOLTIP);
        return new Component[]{Box.createHorizontalStrut(5), pb};
    }

    @Override
    protected ProfilerTable getResultsComponent() {
        return this.treeTable;
    }

    @Override
    public void setData(MemoryResultsSnapshot snapshot, GenericFilter filter, int aggregation) {
        final boolean includeEmpty = filter != null;
        final boolean diff = snapshot instanceof AllocMemoryResultsDiff;
        final AllocMemoryResultsSnapshot _snapshot = (AllocMemoryResultsSnapshot)snapshot;
        String[] _classNames = _snapshot.getClassNames();
        int[] _nTotalAllocObjects = _snapshot.getObjectsCounts();
        long[] _totalAllocObjectsSize = _snapshot.getObjectsSizePerClass();
        int _nTrackedItems = Math.min(_snapshot.getNProfiledClasses(), _classNames.length);
        _nTrackedItems = Math.min(_nTrackedItems, _nTotalAllocObjects.length);
        class Node
        extends PresoObjAllocCCTNode {
            Node(String className, int nTotalAllocObjects, long totalAllocObjectsSize) {
                super(className, (long)nTotalAllocObjects, totalAllocObjectsSize);
            }

            public CCTNode[] getChildren() {
                if (this.children == null) {
                    MemoryCCTManager callGraphManager = new MemoryCCTManager((MemoryResultsSnapshot)_snapshot, _i, true);
                    PresoObjAllocCCTNode root = callGraphManager.getRootNode();
                    this.setChildren(root == null ? new PresoObjAllocCCTNode[]{} : (PresoObjAllocCCTNode[])root.getChildren());
                }
                return this.children;
            }

            public boolean isLeaf() {
                if (this.children == null) {
                    return includeEmpty && this.nCalls == 0L;
                }
                return super.isLeaf();
            }

            public int getChildCount() {
                if (this.children == null) {
                    this.getChildren();
                }
                return super.getChildCount();
            }
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        final HashMap<Node, ClientUtils.SourceCodeSelection> _nodesMap = new HashMap<Node, ClientUtils.SourceCodeSelection>();
        long totalObjects = 0L;
        long _totalObjects = 0L;
        long totalBytes = 0L;
        long _totalBytes = 0L;
        for (int i = 0; i < _nTrackedItems; ++i) {
            Node node;
            if (diff) {
                totalObjects = Math.max(totalObjects, (long)_nTotalAllocObjects[i]);
                _totalObjects = Math.min(_totalObjects, (long)_nTotalAllocObjects[i]);
                totalBytes = Math.max(totalBytes, _totalAllocObjectsSize[i]);
                _totalBytes = Math.min(_totalBytes, _totalAllocObjectsSize[i]);
            } else {
                totalObjects += (long)_nTotalAllocObjects[i];
                totalBytes += _totalAllocObjectsSize[i];
            }
            final int _i = i;
            if (!includeEmpty) {
                if (_nTotalAllocObjects[i] <= 0) continue;
                node = new Node(_classNames[i], _nTotalAllocObjects[i], _totalAllocObjectsSize[i]);
                nodes.add(node);
                _nodesMap.put(node, new ClientUtils.SourceCodeSelection(_classNames[i], "*", null));
                continue;
            }
            if (!filter.passes(_classNames[i].replace('.', '/'))) continue;
            node = new Node(_classNames[i], _nTotalAllocObjects[i], _totalAllocObjectsSize[i]);
            nodes.add(node);
            _nodesMap.put(node, new ClientUtils.SourceCodeSelection(_classNames[i], "*", null));
        }
        final long __totalBytes = !diff ? totalBytes : Math.max(Math.abs(totalBytes), Math.abs(_totalBytes));
        final long __totalObjects = !diff ? totalObjects : Math.max(Math.abs(totalObjects), Math.abs(_totalObjects));
        final PresoObjAllocCCTNode root = PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])nodes.toArray(new PresoObjAllocCCTNode[0]));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AllocTreeTableView.this.nodesMap = _nodesMap;
                AllocTreeTableView.this.renderers[0].setMaxValue(__totalBytes);
                AllocTreeTableView.this.renderers[1].setMaxValue(__totalObjects);
                AllocTreeTableView.this.renderers[0].setDiffMode(diff);
                AllocTreeTableView.this.renderers[1].setDiffMode(diff);
                AllocTreeTableView.this.treeTableModel.setRoot((TreeNode)root);
            }
        });
    }

    @Override
    public void resetData() {
        final PresoObjAllocCCTNode root = PresoObjAllocCCTNode.rootNode((PresoObjAllocCCTNode[])new PresoObjAllocCCTNode[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AllocTreeTableView.this.nodesMap = null;
                AllocTreeTableView.this.renderers[0].setMaxValue(0L);
                AllocTreeTableView.this.renderers[1].setMaxValue(0L);
                AllocTreeTableView.this.renderers[0].setDiffMode(false);
                AllocTreeTableView.this.renderers[1].setDiffMode(false);
                AllocTreeTableView.this.treeTableModel.setRoot((TreeNode)root);
            }
        });
    }

    @Override
    public void showSelectionColumn() {
        this.treeTable.setColumnVisibility(0, true);
    }

    @Override
    public void refreshSelection() {
        this.treeTableModel.dataChanged();
    }

    @Override
    public ExportUtils.ExportProvider[] getExportProviders() {
        ExportUtils.ExportProvider[] exportProviderArray;
        if (this.treeTable.getRowCount() == 0) {
            exportProviderArray = null;
        } else {
            ExportUtils.ExportProvider[] exportProviderArray2 = new ExportUtils.ExportProvider[4];
            exportProviderArray2[0] = new ExportUtils.CSVExportProvider(this.treeTable);
            exportProviderArray2[1] = new ExportUtils.HTMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED);
            exportProviderArray2[2] = new ExportUtils.XMLExportProvider((ProfilerTable)this.treeTable, EXPORT_ALLOCATED);
            exportProviderArray = exportProviderArray2;
            exportProviderArray2[3] = new ExportUtils.PNGExportProvider(this.treeTable);
        }
        return exportProviderArray;
    }

    @Override
    protected abstract void performDefaultAction(ClientUtils.SourceCodeSelection var1);

    protected abstract void populatePopup(JPopupMenu var1, Object var2, ClientUtils.SourceCodeSelection var3);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    HideableBarRenderer.BarDiffMode barDiffMode() {
        return HideableBarRenderer.BarDiffMode.MODE_BAR_DIFF;
    }

    private void initUI() {
        String[] stringArray;
        int offset = this.selection == null ? -1 : 0;
        this.treeTableModel = new AllocTreeTableModel((TreeNode)PrestimeCPUCCTNode.EMPTY);
        this.treeTable = new ProfilerTreeTable(this.treeTableModel, true, true, new int[]{1 + offset}){

            public ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
                return AllocTreeTableView.this.getUserValueForRow(row);
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, Object userValue) {
                AllocTreeTableView.this.populatePopup(popup, value, (ClientUtils.SourceCodeSelection)userValue);
            }

            @Override
            protected void popupShowing() {
                AllocTreeTableView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                AllocTreeTableView.this.popupHidden();
            }
        };
        if (this.selection == null) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = NAME_COLUMN_TOOLTIP;
            stringArray2[1] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray2;
            stringArray2[2] = ALLOC_COUNT_COLUMN_TOOLTIP;
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = SELECTED_COLUMN_TOOLTIP;
            stringArray3[1] = NAME_COLUMN_TOOLTIP;
            stringArray3[2] = ALLOC_SIZE_COLUMN_TOOLTIP;
            stringArray = stringArray3;
            stringArray3[3] = ALLOC_COUNT_COLUMN_TOOLTIP;
        }
        this.treeTable.setColumnToolTips(stringArray);
        this.treeTable.providePopupMenu(true);
        this.treeTable.setDefaultAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = AllocTreeTableView.this.treeTable.getSelectedRow();
                ClientUtils.SourceCodeSelection userValue = AllocTreeTableView.this.getUserValueForRow(row);
                if (userValue != null) {
                    AllocTreeTableView.this.performDefaultAction(userValue);
                }
            }
        });
        this.treeTable.setRootVisible(false);
        this.treeTable.setShowsRootHandles(true);
        this.treeTable.makeTreeAutoExpandable(2);
        this.treeTable.setMainColumn(1 + offset);
        this.treeTable.setFitWidthColumn(1 + offset);
        this.treeTable.setSortColumn(2 + offset);
        this.treeTable.setDefaultSortOrder(1 + offset, SortOrder.ASCENDING);
        if (this.selection != null) {
            this.treeTable.setColumnVisibility(0, false);
        }
        this.renderers = new HideableBarRenderer[2];
        HideableBarRenderer.BarDiffMode barDiffMode = this.barDiffMode();
        this.renderers[0] = new HideableBarRenderer(new NumberPercentRenderer(Formatters.bytesFormat()));
        this.renderers[0].setBarDiffMode(barDiffMode);
        this.renderers[1] = new HideableBarRenderer(new NumberPercentRenderer());
        this.renderers[1].setBarDiffMode(barDiffMode);
        this.renderers[0].setMaxValue(123456789L);
        this.renderers[1].setMaxValue(12345678L);
        if (this.selection != null) {
            this.treeTable.setColumnRenderer(0, new CheckBoxRenderer(){
                private boolean visible;

                @Override
                public void setValue(Object value, int row) {
                    TreePath path = AllocTreeTableView.this.treeTable.getPathForRow(row);
                    this.visible = AllocTreeTableView.this.nodesMap.containsKey((TreeNode)path.getLastPathComponent());
                    if (this.visible) {
                        super.setValue(value, row);
                    }
                }

                @Override
                public void paint(Graphics g) {
                    if (this.visible) {
                        super.paint(g);
                    } else {
                        g.setColor(this.getBackground());
                        g.fillRect(0, 0, this.size.width, this.size.height);
                    }
                }
            });
        }
        this.treeTable.setTreeCellRenderer(new MemoryJavaNameRenderer());
        this.treeTable.setColumnRenderer(2 + offset, this.renderers[0]);
        this.treeTable.setColumnRenderer(3 + offset, this.renderers[1]);
        if (this.selection != null) {
            int w = new JLabel((String)this.treeTable.getColumnName((int)0)).getPreferredSize().width;
            this.treeTable.setDefaultColumnWidth(0, w + 15);
        }
        this.treeTable.setDefaultColumnWidth(2 + offset, this.renderers[0].getOptimalWidth());
        this.treeTable.setDefaultColumnWidth(3 + offset, this.renderers[1].getMaxNoBarWidth());
        ProfilerTableContainer tableContainer = new ProfilerTableContainer(this.treeTable, false, null);
        this.setLayout(new BorderLayout());
        this.add((Component)tableContainer, "Center");
    }

    @Override
    protected ClientUtils.SourceCodeSelection getUserValueForRow(int row) {
        PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)this.treeTable.getValueForRow(row);
        if (node == null || node.isFiltered()) {
            return null;
        }
        String[] name = node.getMethodClassNameAndSig();
        return new ClientUtils.SourceCodeSelection(name[0], name[1], name[2]);
    }

    private class AllocTreeTableModel
    extends ProfilerTreeTableModel.Abstract {
        AllocTreeTableModel(TreeNode root) {
            super(root);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (AllocTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return MemoryView.COLUMN_NAME;
            }
            if (columnIndex == 2) {
                return MemoryView.COLUMN_ALLOCATED_BYTES;
            }
            if (columnIndex == 3) {
                return MemoryView.COLUMN_ALLOCATED_OBJECTS;
            }
            if (columnIndex == 0) {
                return MemoryView.COLUMN_SELECTED;
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (AllocTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return JTree.class;
            }
            if (columnIndex == 2) {
                return Long.class;
            }
            if (columnIndex == 3) {
                return Integer.class;
            }
            if (columnIndex == 0) {
                return Boolean.class;
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return AllocTreeTableView.this.selection == null ? 3 : 4;
        }

        @Override
        public Object getValueAt(TreeNode node, int columnIndex) {
            PresoObjAllocCCTNode allocNode = (PresoObjAllocCCTNode)node;
            if (AllocTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 1) {
                return allocNode.getNodeName();
            }
            if (columnIndex == 2) {
                return allocNode.totalObjSize;
            }
            if (columnIndex == 3) {
                return allocNode.nCalls;
            }
            if (columnIndex == 0) {
                if (AllocTreeTableView.this.selection.isEmpty()) {
                    return Boolean.FALSE;
                }
                return AllocTreeTableView.this.selection.contains(AllocTreeTableView.this.nodesMap.get(node));
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, TreeNode node, int columnIndex) {
            if (AllocTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex == 0) {
                if (Boolean.TRUE.equals(aValue)) {
                    AllocTreeTableView.this.selection.add(AllocTreeTableView.this.nodesMap.get(node));
                } else {
                    AllocTreeTableView.this.selection.remove(AllocTreeTableView.this.nodesMap.get(node));
                }
            }
        }

        @Override
        public boolean isCellEditable(TreeNode node, int columnIndex) {
            if (AllocTreeTableView.this.selection == null) {
                ++columnIndex;
            }
            if (columnIndex != 0) {
                return false;
            }
            return AllocTreeTableView.this.nodesMap.containsKey(node);
        }
    }
}

