/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssLength;

public class CssUnitsCSS1 {
    private static final String[] relative_length_units = new String[]{"em", "ex", "px"};
    private static final String[] absolute_length_units = new String[]{"in", "cm", "mm", "pt", "pc"};

    protected static String getRelativeLengthUnit(String unit) {
        for (String s : relative_length_units) {
            if (!s.equals(unit)) continue;
            return s;
        }
        return null;
    }

    protected static String getAbsoluteLengthUnit(String unit) {
        for (String s : absolute_length_units) {
            if (!s.equals(unit)) continue;
            return s;
        }
        return null;
    }

    protected static void parseLengthUnit(String unit, CssLength length, ApplContext ac) throws InvalidParamException {
        String matchedUnit = CssUnitsCSS1.getRelativeLengthUnit(unit);
        if (matchedUnit != null) {
            length.absolute = false;
        } else {
            matchedUnit = CssUnitsCSS1.getAbsoluteLengthUnit(unit);
            if (matchedUnit == null) {
                throw new InvalidParamException("unit", unit, ac);
            }
            length.absolute = true;
        }
        length.unit = matchedUnit;
    }
}

