/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.List;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import org.fife.ui.rtextarea.ChangableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class ConfigurableCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    public static final int MIN_STYLE = 0;
    public static final int VERTICAL_LINE_STYLE = 0;
    public static final int UNDERLINE_STYLE = 1;
    public static final int BLOCK_STYLE = 2;
    public static final int BLOCK_BORDER_STYLE = 3;
    public static final int MAX_STYLE = 3;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    private RTextArea component;
    boolean visible;
    boolean active;
    int dot;
    int mark;
    List selectionTagList;
    boolean selectionVisible;
    Timer flasher;
    Point magicCaretPosition;
    Object selectionTag;
    transient Handler handler = new Handler();
    private transient NavigationFilter.FilterBypass filterBypass;
    private static transient Action selectWord = null;
    private static transient Action selectLine = null;
    private boolean ownsSelection;
    private boolean forceCaretPositionChange;
    private transient boolean shouldHandleRelease;
    private transient MouseEvent selectedWordEvent = null;
    private Segment seg = new Segment();
    private int style;
    private Highlighter.HighlightPainter selectionPainter;

    public ConfigurableCaret() {
        this(0);
    }

    public ConfigurableCaret(int n) {
        this.setStyle(n);
        this.selectionPainter = new ChangableHighlightPainter();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    private void adjustCaret(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 1) != 0 && this.getDot() != -1) {
            this.moveCaret(mouseEvent);
        } else {
            this.positionCaret(mouseEvent);
        }
    }

    void adjustCaretAndFocus(MouseEvent mouseEvent) {
        this.adjustCaret(mouseEvent);
        this.adjustFocus(false);
    }

    private void adjustFocus(boolean bl) {
        if (this.component != null && this.component.isEnabled() && this.component.isRequestFocusEnabled()) {
            if (bl) {
                this.component.requestFocusInWindow();
            } else {
                this.component.requestFocus();
            }
        }
    }

    protected void adjustVisibility(Rectangle rectangle) {
        if (this.component == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.component.scrollRectToVisible(rectangle);
        } else {
            SwingUtilities.invokeLater(new SafeScroller(rectangle));
        }
    }

    void changeCaretPosition(int n) {
        this.repaint();
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.dot = n;
        this.fireStateChanged();
        this.updateSystemSelection();
        this.setMagicCaretPosition(null);
        Runnable runnable = new Runnable(){

            public void run() {
                ConfigurableCaret.this.repaintNewCaret();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x - 1;
            this.y = rectangle.y;
            this.width = rectangle.width + 4;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        jTextComponent.removeMouseListener(this);
        jTextComponent.removeMouseMotionListener(this);
        jTextComponent.removeFocusListener(this);
        jTextComponent.removePropertyChangeListener(this.handler);
        Document document = jTextComponent.getDocument();
        if (document != null) {
            document.removeDocumentListener(this.handler);
        }
        ConfigurableCaret configurableCaret = this;
        synchronized (configurableCaret) {
            this.component = null;
        }
        if (this.flasher != null) {
            this.flasher.stop();
        }
    }

    private void ensureValidPosition() {
        int n = this.component.getDocument().getLength();
        if (this.dot > n || this.mark > n) {
            this.handleSetDot(n);
        }
    }

    public boolean equals(Object object) {
        return this == object;
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ChangeListener == null ? ConfigurableCaret.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.component.isEnabled()) {
            if (this.component.isEditable()) {
                this.setVisible(true);
            }
            this.setSelectionVisible(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
        this.setSelectionVisible(this.ownsSelection || focusEvent.isTemporary());
    }

    public int getBlinkRate() {
        return this.flasher == null ? 0 : this.flasher.getDelay();
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    private ClipboardOwner getClipboardOwner() {
        return this.handler;
    }

    protected RTextArea getTextArea() {
        return this.component;
    }

    public int getDot() {
        return this.dot;
    }

    private NavigationFilter.FilterBypass getFilterBypass() {
        if (this.filterBypass == null) {
            this.filterBypass = new DefaultFilterBypass();
        }
        return this.filterBypass;
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public int getMark() {
        return this.mark;
    }

    public boolean getRoundedSelectionEdges() {
        return ((ChangableHighlightPainter)this.getSelectionPainter()).getRoundedEdges();
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return this.selectionPainter;
    }

    public int getStyle() {
        return this.style;
    }

    private Clipboard getSystemSelection() {
        try {
            return this.component.getToolkit().getSystemSelection();
        }
        catch (HeadlessException headlessException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    protected void handleMoveDot(int n) {
        Highlighter highlighter;
        this.changeCaretPosition(n);
        if (this.selectionVisible && (highlighter = this.component.getHighlighter()) != null) {
            int n2;
            int n3 = Math.min(n, this.mark);
            if (n3 == (n2 = Math.max(n, this.mark))) {
                if (this.selectionTag != null) {
                    highlighter.removeHighlight(this.selectionTag);
                    this.selectionTag = null;
                }
            } else {
                try {
                    if (this.selectionTag != null) {
                        highlighter.changeHighlight(this.selectionTag, n3, n2);
                    } else {
                        Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                        this.selectionTag = highlighter.addHighlight(n3, n2, highlightPainter);
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw new InternalError("Bad caret position");
                }
            }
        }
    }

    protected void handleSetDot(int n) {
        Highlighter highlighter;
        Document document = this.component.getDocument();
        if (document != null) {
            n = Math.min(n, document.getLength());
        }
        this.mark = n = Math.max(n, 0);
        if (this.dot != n || this.selectionTag != null || this.forceCaretPositionChange) {
            this.changeCaretPosition(n);
        }
        if ((highlighter = this.component.getHighlighter()) != null && this.selectionTag != null) {
            highlighter.removeHighlight(this.selectionTag);
            this.selectionTag = null;
        }
    }

    public void install(JTextComponent jTextComponent) {
        if (!(jTextComponent instanceof RTextArea)) {
            throw new IllegalArgumentException("c must be instance of RTextArea");
        }
        this.component = (RTextArea)jTextComponent;
        Document document = jTextComponent.getDocument();
        this.mark = 0;
        this.dot = 0;
        if (document != null) {
            document.addDocumentListener(this.handler);
        }
        jTextComponent.addPropertyChangeListener(this.handler);
        jTextComponent.addFocusListener(this);
        jTextComponent.addMouseListener(this);
        jTextComponent.addMouseMotionListener(this);
        if (this.component.hasFocus()) {
            this.focusGained(null);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed()) {
            JTextComponent jTextComponent;
            int n = mouseEvent.getClickCount();
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n > 1) {
                    n = 2 + n % 2;
                }
                switch (n) {
                    case 1: {
                        this.selectedWordEvent = null;
                        break;
                    }
                    case 2: {
                        this.selectWord(mouseEvent);
                        this.selectedWordEvent = null;
                        break;
                    }
                    case 3: {
                        Action action = null;
                        ActionMap actionMap = this.component.getActionMap();
                        if (actionMap != null) {
                            action = actionMap.get("select-line");
                        }
                        if (action == null) {
                            if (selectLine == null) {
                                selectLine = new RTextAreaEditorKit.SelectLineAction();
                            }
                            action = selectLine;
                        }
                        action.actionPerformed(new ActionEvent(this.component, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
                    }
                }
            } else if (SwingUtilities.isMiddleMouseButton(mouseEvent) && n == 1 && this.component.isEditable() && this.component.isEnabled() && (jTextComponent = (JTextComponent)mouseEvent.getSource()) != null) {
                try {
                    Toolkit toolkit = jTextComponent.getToolkit();
                    Clipboard clipboard = toolkit.getSystemSelection();
                    if (clipboard != null) {
                        Transferable transferable;
                        this.adjustCaret(mouseEvent);
                        TransferHandler transferHandler = jTextComponent.getTransferHandler();
                        if (transferHandler != null && (transferable = clipboard.getContents(null)) != null) {
                            transferHandler.importData(jTextComponent, transferable);
                        }
                        this.adjustFocus(true);
                    } else {
                        this.component.paste();
                    }
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.moveCaret(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (mouseEvent.isConsumed()) {
                this.shouldHandleRelease = true;
            } else {
                this.shouldHandleRelease = false;
                this.adjustCaretAndFocus(mouseEvent);
                if (mouseEvent.getClickCount() == 2) {
                    this.selectWord(mouseEvent);
                }
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.shouldHandleRelease && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.adjustCaretAndFocus(mouseEvent);
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = this.component.getUI().viewToModel(this.component, point);
        this.moveDot(n);
    }

    public void moveDot(int n) {
        if (!this.component.isEnabled()) {
            this.setDot(n);
            return;
        }
        if (n != this.dot) {
            NavigationFilter navigationFilter = this.component.getNavigationFilter();
            if (navigationFilter != null) {
                navigationFilter.moveDot(this.getFilterBypass(), n, Position.Bias.Forward);
            } else {
                this.handleMoveDot(n);
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            try {
                graphics.setColor(this.component.getCaretColor());
                TextUI textUI = this.component.getUI();
                Rectangle rectangle = textUI.modelToView(this.component, this.dot);
                this.validateWidth(rectangle);
                rectangle.height -= 2;
                switch (this.style) {
                    case 2: {
                        graphics.setXORMode(Color.WHITE);
                        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        break;
                    }
                    case 3: {
                        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height);
                        break;
                    }
                    case 1: {
                        graphics.setXORMode(Color.WHITE);
                        int n = rectangle.y + rectangle.height;
                        graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 1, n);
                        break;
                    }
                    default: {
                        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
                        break;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        int n = this.component.getUI().viewToModel(this.component, point);
        this.setDot(n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.setStyle(objectInputStream.readInt());
        this.handler = new Handler();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    protected final synchronized void repaint() {
        if (this.component != null) {
            this.component.repaint(this.x, this.y, this.width, this.height);
        }
    }

    void repaintNewCaret() {
        if (this.component != null) {
            TextUI textUI = this.component.getUI();
            Document document = this.component.getDocument();
            if (textUI != null && document != null) {
                Rectangle rectangle;
                try {
                    rectangle = textUI.modelToView(this.component, this.dot);
                    this.validateWidth(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    rectangle = null;
                }
                if (rectangle != null) {
                    this.adjustVisibility(rectangle);
                    if (this.getMagicCaretPosition() == null) {
                        this.setMagicCaretPosition(new Point(rectangle.x, rectangle.y));
                    }
                }
                this.damage(rectangle);
            }
        }
    }

    private void selectWord(MouseEvent mouseEvent) {
        if (this.selectedWordEvent != null && this.selectedWordEvent.getX() == mouseEvent.getX() && this.selectedWordEvent.getY() == mouseEvent.getY()) {
            return;
        }
        Action action = null;
        ActionMap actionMap = this.component.getActionMap();
        if (actionMap != null) {
            action = actionMap.get("select-word");
        }
        if (action == null) {
            if (selectWord == null) {
                selectWord = new RTextAreaEditorKit.SelectWordAction();
            }
            action = selectWord;
        }
        action.actionPerformed(new ActionEvent(this.component, 1001, null, mouseEvent.getWhen(), mouseEvent.getModifiers()));
        this.selectedWordEvent = mouseEvent;
    }

    public void setBlinkRate(int n) {
        if (n != 0) {
            if (this.flasher == null) {
                this.flasher = new Timer(n, this.handler);
            }
            this.flasher.setDelay(n);
        } else if (this.flasher != null) {
            this.flasher.stop();
            this.flasher.removeActionListener(this.handler);
            this.flasher = null;
        }
    }

    public void setDot(int n) {
        NavigationFilter navigationFilter = this.component.getNavigationFilter();
        if (navigationFilter != null) {
            navigationFilter.setDot(this.getFilterBypass(), n, Position.Bias.Forward);
        } else {
            this.handleSetDot(n);
        }
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public void setRoundedSelectionEdges(boolean bl) {
        ((ChangableHighlightPainter)this.getSelectionPainter()).setRoundedEdges(bl);
    }

    public void setSelectionVisible(boolean bl) {
        if (bl != this.selectionVisible) {
            this.selectionVisible = bl;
            if (this.selectionVisible) {
                Highlighter highlighter = this.component.getHighlighter();
                if (this.dot != this.mark && highlighter != null && this.selectionTag == null) {
                    int n = Math.min(this.dot, this.mark);
                    int n2 = Math.max(this.dot, this.mark);
                    Highlighter.HighlightPainter highlightPainter = this.getSelectionPainter();
                    try {
                        this.selectionTag = highlighter.addHighlight(n, n2, highlightPainter);
                    }
                    catch (BadLocationException badLocationException) {
                        this.selectionTag = null;
                    }
                }
            } else if (this.selectionTag != null) {
                Highlighter highlighter = this.component.getHighlighter();
                highlighter.removeHighlight(this.selectionTag);
                this.selectionTag = null;
            }
        }
    }

    public void setStyle(int n) {
        if (n < 0 || n > 3) {
            n = 0;
        }
        this.style = n;
        if (this.flasher != null && this.flasher.isRunning()) {
            this.visible = true;
            this.flasher.restart();
        }
        this.repaint();
    }

    public void setVisible(boolean bl) {
        if (this.component != null) {
            this.active = bl;
            TextUI textUI = this.component.getUI();
            if (this.visible != bl) {
                this.visible = bl;
                try {
                    Rectangle rectangle = textUI.modelToView(this.component, this.dot);
                    this.validateWidth(rectangle);
                    this.damage(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (this.flasher != null) {
            if (this.visible) {
                this.flasher.start();
            } else {
                this.flasher.stop();
            }
        }
    }

    public String toString() {
        String string = "Dot=" + this.dot;
        string = string + " Mark=" + this.mark;
        return string;
    }

    private void updateSystemSelection() {
        Clipboard clipboard;
        if (this.dot != this.mark && this.component != null && (clipboard = this.getSystemSelection()) != null) {
            String string = null;
            string = this.component.getSelectedText();
            clipboard.setContents(new StringSelection(string), this.getClipboardOwner());
            this.ownsSelection = true;
        }
    }

    private final void validateWidth(Rectangle rectangle) {
        if (rectangle != null && rectangle.width <= 1) {
            try {
                this.component.getDocument().getText(this.dot, 1, this.seg);
                Font font = this.component.getFont();
                FontMetrics fontMetrics = this.component.getFontMetrics(font);
                rectangle.width = fontMetrics.charWidth(this.seg.array[this.seg.offset]);
                if (rectangle.width == 0) {
                    rectangle.width = fontMetrics.charWidth(' ');
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                rectangle.width = 8;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.getStyle());
    }

    private class DefaultFilterBypass
    extends NavigationFilter.FilterBypass {
        private DefaultFilterBypass() {
        }

        public Caret getCaret() {
            return ConfigurableCaret.this;
        }

        public void setDot(int n, Position.Bias bias) {
            ConfigurableCaret.this.handleSetDot(n);
        }

        public void moveDot(int n, Position.Bias bias) {
            ConfigurableCaret.this.handleMoveDot(n);
        }
    }

    class Handler
    implements PropertyChangeListener,
    DocumentListener,
    ActionListener,
    ClipboardOwner {
        Handler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ((ConfigurableCaret.this.width == 0 || ConfigurableCaret.this.height == 0) && ConfigurableCaret.this.component != null) {
                TextUI textUI = ConfigurableCaret.this.component.getUI();
                try {
                    Rectangle rectangle = textUI.modelToView(ConfigurableCaret.this.component, ConfigurableCaret.this.dot);
                    if (rectangle != null && rectangle.width != 0 && rectangle.height != 0) {
                        ConfigurableCaret.this.validateWidth(rectangle);
                        ConfigurableCaret.this.damage(rectangle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            ConfigurableCaret.this.visible = !ConfigurableCaret.this.visible;
            ConfigurableCaret.this.repaint();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            int n;
            if (!SwingUtilities.isEventDispatchThread()) {
                if ((documentEvent.getOffset() <= ConfigurableCaret.this.dot || documentEvent.getOffset() <= ConfigurableCaret.this.mark) && ConfigurableCaret.this.selectionTag != null) {
                    try {
                        ConfigurableCaret.this.component.getHighlighter().changeHighlight(ConfigurableCaret.this.selectionTag, Math.min(ConfigurableCaret.this.dot, ConfigurableCaret.this.mark), Math.max(ConfigurableCaret.this.dot, ConfigurableCaret.this.mark));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                return;
            }
            int n2 = documentEvent.getOffset();
            int n3 = documentEvent.getLength();
            int n4 = ConfigurableCaret.this.dot;
            short s = 0;
            if (ConfigurableCaret.this.component.inUndoRedo()) {
                ConfigurableCaret.this.setDot(n2 + n3);
                return;
            }
            if (n4 >= n2) {
                n4 += n3;
                s = (short)(s | 1);
            }
            if ((n = ConfigurableCaret.this.mark) >= n2) {
                n += n3;
                s = (short)(s | 2);
            }
            if (s != 0) {
                if (n == n4) {
                    ConfigurableCaret.this.setDot(n4);
                    ConfigurableCaret.this.ensureValidPosition();
                } else {
                    ConfigurableCaret.this.setDot(n);
                    if (ConfigurableCaret.this.getDot() == n) {
                        ConfigurableCaret.this.moveDot(n4);
                    }
                    ConfigurableCaret.this.ensureValidPosition();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!SwingUtilities.isEventDispatchThread()) {
                int n = ConfigurableCaret.this.component.getDocument().getLength();
                ConfigurableCaret.this.dot = Math.min(ConfigurableCaret.this.dot, n);
                ConfigurableCaret.this.mark = Math.min(ConfigurableCaret.this.mark, n);
                if ((documentEvent.getOffset() < ConfigurableCaret.this.dot || documentEvent.getOffset() < ConfigurableCaret.this.mark) && ConfigurableCaret.this.selectionTag != null) {
                    try {
                        ConfigurableCaret.this.component.getHighlighter().changeHighlight(ConfigurableCaret.this.selectionTag, Math.min(ConfigurableCaret.this.dot, ConfigurableCaret.this.mark), Math.max(ConfigurableCaret.this.dot, ConfigurableCaret.this.mark));
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                return;
            }
            int n = documentEvent.getOffset();
            int n2 = n + documentEvent.getLength();
            int n3 = ConfigurableCaret.this.dot;
            int n4 = ConfigurableCaret.this.mark;
            if (ConfigurableCaret.this.component.inUndoRedo()) {
                ConfigurableCaret.this.setDot(n);
                return;
            }
            if (n3 >= n2) {
                n3 -= n2 - n;
            } else if (n3 >= n) {
                n3 = n;
            }
            if (n4 >= n2) {
                n4 -= n2 - n;
            } else if (n4 >= n) {
                n4 = n;
            }
            if (n4 == n3) {
                ConfigurableCaret.this.forceCaretPositionChange = true;
                try {
                    ConfigurableCaret.this.setDot(n3);
                }
                finally {
                    ConfigurableCaret.this.forceCaretPositionChange = false;
                }
                ConfigurableCaret.this.ensureValidPosition();
            } else {
                ConfigurableCaret.this.setDot(n4);
                if (ConfigurableCaret.this.getDot() == n4) {
                    ConfigurableCaret.this.moveDot(n3);
                }
                ConfigurableCaret.this.ensureValidPosition();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!SwingUtilities.isEventDispatchThread()) {
                return;
            }
            if (ConfigurableCaret.this.component.inUndoRedo()) {
                ConfigurableCaret.this.setDot(documentEvent.getOffset() + documentEvent.getLength());
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object instanceof Document || object2 instanceof Document) {
                ConfigurableCaret.this.setDot(0);
                if (object != null) {
                    ((Document)object).removeDocumentListener(this);
                }
                if (object2 != null) {
                    ((Document)object2).addDocumentListener(this);
                }
            } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (ConfigurableCaret.this.component.isFocusOwner()) {
                    if (bl == Boolean.TRUE) {
                        if (ConfigurableCaret.this.component.isEditable()) {
                            ConfigurableCaret.this.setVisible(true);
                        }
                        ConfigurableCaret.this.setSelectionVisible(true);
                    } else {
                        ConfigurableCaret.this.setVisible(false);
                        ConfigurableCaret.this.setSelectionVisible(false);
                    }
                }
            }
        }

        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
            if (ConfigurableCaret.this.ownsSelection) {
                ConfigurableCaret.this.ownsSelection = false;
                if (ConfigurableCaret.this.component != null && !ConfigurableCaret.this.component.hasFocus()) {
                    ConfigurableCaret.this.setSelectionVisible(false);
                }
            }
        }
    }

    class SafeScroller
    implements Runnable {
        private Rectangle r;

        SafeScroller(Rectangle rectangle) {
            this.r = rectangle;
        }

        public void run() {
            if (ConfigurableCaret.this.component != null) {
                ConfigurableCaret.this.component.scrollRectToVisible(this.r);
            }
        }
    }
}

