/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getfilesrowscount;

import java.io.BufferedInputStream;
import java.io.InputStreamReader;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCountData;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCountMeta;
import org.pentaho.di.trans.steps.getfilesrowscount.Messages;

public class GetFilesRowsCount
extends BaseStep
implements StepInterface {
    private GetFilesRowsCountMeta meta;
    private GetFilesRowsCountData data;
    private static final int BUFFER_SIZE_INPUT_STREAM = 500;

    public GetFilesRowsCount(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] getOneRow() throws KettleException {
        Object[] r;
        if (!this.openNextFile()) {
            return null;
        }
        try {
            if (this.meta.isFileField()) {
                r = (Object[])this.data.readrow.clone();
                r = RowDataUtil.resizeArray((Object[])r, (int)this.data.outputRowMeta.size());
            } else {
                r = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            }
            r[this.data.totalpreviousfields] = this.data.rownr;
            if (this.meta.includeCountFiles()) {
                r[this.data.totalpreviousfields + 1] = this.data.filenr;
            }
            this.incrementLinesInput();
        }
        catch (Exception e) {
            throw new KettleException("Unable to read row from file", (Throwable)e);
        }
        return r;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            if (!this.meta.isFileField() && this.data.last_file || this.meta.isFileField()) {
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("GetFilesRowsCount.Log.TotalRowsFiles"), new Object[]{this.data.rownr, this.data.filenr});
                }
            }
        }
        catch (KettleException e) {
            this.logError(Messages.getString("GetFilesRowsCount.ErrorInStepRunning", e.getMessage()));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    private void getRowNumber() throws KettleException {
        try {
            if (this.data.file.getType() == FileType.FILE) {
                this.data.fr = KettleVFS.getInputStream((FileObject)this.data.file);
                this.data.isr = new InputStreamReader(new BufferedInputStream(this.data.fr, 500));
                char c = '\u0000';
                this.data.lineStringBuffer.setLength(0);
                while (c >= '\u0000') {
                    c = this.data.isr.read();
                    if (c != this.data.separator) continue;
                    ++this.data.rownr;
                }
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), Messages.getString("GetFilesRowsCount.Log.RowsInFile", this.data.file.toString(), "" + this.data.rownr), new Object[0]);
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private boolean openNextFile() {
        if (this.data.last_file) {
            return false;
        }
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= (long)this.data.files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("GetFilesRowsCount.Log.FinishedProcessing"));
                    }
                    return false;
                }
                this.data.last_file = this.data.filenr == (long)(this.data.files.nrOfFiles() - 1);
                this.data.file = this.data.files.getFile((int)this.data.filenr);
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(Messages.getString("GetFilesRowsCount.Log.FinishedProcessing"));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    if (Const.isEmpty((String)this.meta.setOutputFilenameField())) {
                        this.logError(Messages.getString("GetFilesRowsCount.Log.NoField"));
                        throw new KettleException(Messages.getString("GetFilesRowsCount.Log.NoField"));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.setOutputFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(Messages.getString("GetFilesRowsCount.Log.ErrorFindingField", this.meta.setOutputFilenameField()));
                            throw new KettleException(Messages.getString("GetFilesRowsCount.Exception.CouldnotFindField", this.meta.setOutputFilenameField()));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("GetFilesRowsCount.Log.FilenameInStream", this.meta.setOutputFilenameField(), filename), new Object[0]);
                }
                this.data.file = KettleVFS.getFileObject((String)filename);
                if (this.meta.isFileField()) {
                    this.data.rownr = 0L;
                }
            }
            ++this.data.filenr;
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(Messages.getString("GetFilesRowsCount.Log.FileAddedResult"));
                this.addResultFile(resultFile);
            }
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("GetFilesRowsCount.Log.OpeningFile", this.data.file.toString()));
            }
            this.getRowNumber();
            if (this.log.isDetailed()) {
                this.logDetailed(Messages.getString("GetFilesRowsCount.Log.FileOpened", this.data.file.toString()));
            }
        }
        catch (Exception e) {
            this.logError(Messages.getString("GetFilesRowsCount.Log.UnableToOpenFile", "" + this.data.filenr, this.data.file.toString(), e.toString()));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetFilesRowsCountMeta)smi;
        this.data = (GetFilesRowsCountData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getRowSeparatorFormat().equals("CUSTOM") && Const.isEmpty((String)this.meta.getRowSeparator())) {
                this.log.logError(Messages.getString("GetFilesRowsCount.Error.NoSeparator.Title"), Messages.getString("GetFilesRowsCount.Error.NoSeparator.Msg"), new Object[0]);
                this.setErrors(1L);
                this.stopAll();
            } else if (this.meta.getRowSeparatorFormat().equals("CR")) {
                this.data.separator = (char)10;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(Messages.getString("GetFilesRowsCount.Log.Separator.Title"), Messages.getString("GetFilesRowsCount.Log.Separatoris.Infos") + " \\n", new Object[0]);
                }
            } else if (this.meta.getRowSeparatorFormat().equals("LF")) {
                this.data.separator = (char)13;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(Messages.getString("GetFilesRowsCount.Log.Separator.Title"), Messages.getString("GetFilesRowsCount.Log.Separatoris.Infos") + " \\r", new Object[0]);
                }
            } else if (this.meta.getRowSeparatorFormat().equals("TAB")) {
                this.data.separator = (char)9;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(Messages.getString("GetFilesRowsCount.Log.Separator.Title"), Messages.getString("GetFilesRowsCount.Log.Separatoris.Infos") + " \\t", new Object[0]);
                }
            } else {
                this.data.separator = this.environmentSubstitute(this.meta.getRowSeparator()).charAt(0);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(Messages.getString("GetFilesRowsCount.Log.Separator.Title"), Messages.getString("GetFilesRowsCount.Log.Separatoris.Infos") + " " + this.data.separator, new Object[0]);
                }
            }
            if (!this.meta.isFileField()) {
                this.data.files = this.meta.getFiles(this);
                if (this.data.files == null || this.data.files.nrOfFiles() == 0) {
                    this.logError(Messages.getString("GetFilesRowsCount.Log.NoFiles"));
                    return false;
                }
                try {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                }
                catch (Exception e) {
                    this.logError("Error initializing step: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.rownr = 0L;
            this.data.filenr = 0L;
            this.data.totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetFilesRowsCountMeta)smi;
        this.data = (GetFilesRowsCountData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.data.is != null) {
            try {
                this.data.is.close();
                this.data.is = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.data.isr != null) {
            try {
                this.data.isr.close();
                this.data.isr = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.lineStringBuffer != null) {
            this.data.lineStringBuffer = null;
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

