/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.mapviewer;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.sf.freecol.client.gui.mapviewer.TileBounds;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;

public final class MapViewerBounds {
    private Dimension size = null;
    private Tile focus = null;
    private int scrollSpeed = 1;
    private Point mapFocusPoint = null;
    private Map.Position topLeftVisibleTile = new Map.Position(-1, -1);
    private Point topLeftVisibleTilePoint = new Point(0, 0);
    private Map.Position bottomRightVisibleTile = new Map.Position(-1, -1);
    private TileBounds tileBounds;

    MapViewerBounds() {
        this.size = new Dimension(0, 0);
        this.tileBounds = new TileBounds(new Dimension(0, 0), 1.0f);
    }

    void updateSizeVariables(TileBounds tileBounds) {
        TileBounds oldTileBounds = this.tileBounds;
        this.tileBounds = tileBounds;
        if (oldTileBounds != null && this.mapFocusPoint != null) {
            this.mapFocusPoint = new Point(this.mapFocusPoint.x * tileBounds.getWidth() / oldTileBounds.getWidth(), this.mapFocusPoint.y * tileBounds.getHalfHeight() / oldTileBounds.getHalfHeight());
        }
        this.positionMap();
    }

    public int setOffsetFocus(Tile tile) {
        if (tile == null) {
            return 0;
        }
        this.setFocus(tile);
        this.positionMap();
        int ret = 0;
        int moveX = -1;
        Map map = tile.getMap();
        int tx = tile.getX();
        int ty = tile.getY();
        int width = this.bottomRightVisibleTile.getX() - this.topLeftVisibleTile.getX();
        if (this.topLeftVisibleTile.getX() <= 0) {
            if (tx <= width / 4) {
                ret = -1;
            } else if (tx >= 3 * width / 4) {
                ret = 1;
            } else {
                moveX = tx + width / 4;
                ret = -1;
            }
        } else if (this.bottomRightVisibleTile.getX() >= width - 1) {
            if (tx >= this.bottomRightVisibleTile.getX() - width / 4) {
                ret = 1;
            } else if (tx <= this.bottomRightVisibleTile.getX() - 3 * width / 4) {
                ret = -1;
            } else {
                moveX = tx - width / 4;
                ret = 1;
            }
        } else {
            moveX = tx - width / 4;
            ret = 1;
        }
        if (moveX >= 0) {
            Tile other = map.getTile(moveX, ty);
            this.setFocus(other);
        } else {
            this.setFocus(tile);
        }
        return ret;
    }

    public boolean scrollMap(Direction direction) {
        Tile extraScrollTile;
        Tile t = this.getFocus();
        if (t == null) {
            this.scrollSpeed = 1;
            return false;
        }
        int fx = t.getX();
        int fy = t.getY();
        if ((t = t.getNeighbourOrNull(direction)) == null) {
            this.scrollSpeed = 1;
            return false;
        }
        if (Direction.longSides.contains(direction) && (extraScrollTile = t.getNeighbourOrNull(direction)) != null) {
            t = extraScrollTile;
        }
        int tx = t.getX();
        int ty = t.getY();
        int scrollX = this.mapFocusPoint.x;
        int scrollY = this.mapFocusPoint.y;
        ++this.scrollSpeed;
        if (tx > fx) {
            scrollX += 1 + this.scrollSpeed;
            if (ty > fy) {
                scrollY += 1 + this.scrollSpeed;
            } else if (ty < fy) {
                scrollY -= 1 + this.scrollSpeed;
            }
        } else if (tx < fx) {
            scrollX -= 1 + this.scrollSpeed;
            if (ty > fy) {
                scrollY += 1 + this.scrollSpeed;
            } else if (ty < fy) {
                scrollY -= 1 + this.scrollSpeed;
            }
        } else if (ty > fy) {
            scrollY += 1 + this.scrollSpeed;
        } else if (ty < fy) {
            scrollY -= 1 + this.scrollSpeed;
        } else {
            this.scrollSpeed = 1;
            return false;
        }
        this.setFocusMapPoint(new Point(scrollX, scrollY));
        return true;
    }

    public boolean onScreen(Tile tile) {
        return tile.getX() - 1 > this.topLeftVisibleTile.getX() && tile.getX() + 2 < this.bottomRightVisibleTile.getX() && tile.getY() - 2 > this.topLeftVisibleTile.getY() && tile.getY() + 3 < this.bottomRightVisibleTile.getY();
    }

    public Point calculateTilePosition(Tile tile, boolean rhs) {
        if (!this.isTileVisible(tile)) {
            return null;
        }
        Point p = this.tileToPoint(tile);
        if (!rhs) {
            return p;
        }
        return new Point(p.x + this.tileBounds.getWidth(), p.y);
    }

    public Point calculateCenterTilePosition(Tile tile) {
        if (!this.isTileVisible(tile)) {
            return null;
        }
        Point p = this.tileToPoint(tile);
        return new Point(p.x + this.tileBounds.getHalfWidth(), p.y + this.tileBounds.getHalfHeight());
    }

    public boolean setFocus(Tile focus) {
        if (focus == null || this.focus == focus) {
            return false;
        }
        this.focus = focus;
        this.setFocusMapPoint(new Point(this.tileBounds.getHalfWidth() + focus.getX() * this.tileBounds.getWidth() + (focus.getY() & 1) * this.tileBounds.getHalfWidth(), this.tileBounds.getHalfHeight() + focus.getY() * this.tileBounds.getHalfHeight()));
        return true;
    }

    public boolean setFocusMapPoint(Point mapFocusPoint) {
        if (this.focus == null) {
            return false;
        }
        Map map = this.focus.getMap();
        int mapFocusPointX = MapViewerBounds.inRange(this.tileBounds.getHalfWidth(), mapFocusPoint.x, map.getWidth() * this.tileBounds.getWidth());
        int mapFocusPointY = MapViewerBounds.inRange(this.tileBounds.getHalfHeight(), mapFocusPoint.y, map.getHeight() * this.tileBounds.getHalfHeight() - this.tileBounds.getHalfHeight());
        this.mapFocusPoint = new Point(mapFocusPointX, mapFocusPointY);
        int tileX = (mapFocusPoint.x - this.tileBounds.getHalfWidth()) / this.tileBounds.getWidth();
        int tileY = (mapFocusPoint.y - this.tileBounds.getHalfHeight()) / this.tileBounds.getHalfHeight();
        this.focus = map.getTile(MapViewerBounds.inRange(0, tileX, map.getWidth() - 1), MapViewerBounds.inRange(0, tileY, map.getHeight() - 1));
        this.positionMap();
        return true;
    }

    public Point getFocusMapPoint() {
        return this.mapFocusPoint;
    }

    private static int inRange(int min, int value, int max) {
        return Math.min(max, Math.max(min, value));
    }

    void positionMap() {
        if (this.focus == null) {
            return;
        }
        int focusTileX = (this.mapFocusPoint.x - this.tileBounds.getHalfWidth()) / this.tileBounds.getWidth();
        int focusTileY = (this.mapFocusPoint.y - this.tileBounds.getHalfHeight()) / this.tileBounds.getHalfHeight();
        int extraSpaceFocusTileX = (this.mapFocusPoint.x - this.tileBounds.getHalfWidth()) % this.tileBounds.getWidth();
        int extraSpaceFocusTileY = (this.mapFocusPoint.y - this.tileBounds.getHalfHeight()) % this.tileBounds.getHalfHeight();
        int topFullTiles = (this.size.height / 2 - extraSpaceFocusTileY) / this.tileBounds.getHalfHeight();
        int extraSpaceY = (this.size.height / 2 - extraSpaceFocusTileY) % this.tileBounds.getHalfHeight();
        int topTiles = topFullTiles + (extraSpaceY > 0 ? 1 : 0);
        int topLeftTileY = focusTileY - topTiles;
        int leftFullTiles = (this.size.width / 2 - extraSpaceFocusTileX) / this.tileBounds.getWidth();
        int extraSpaceX = (this.size.width / 2 - extraSpaceFocusTileX) % this.tileBounds.getWidth();
        int leftTiles = leftFullTiles + (extraSpaceX > 0 ? 1 : 0);
        this.topLeftVisibleTile = new Map.Position(focusTileX - leftTiles, topLeftTileY);
        this.topLeftVisibleTilePoint = new Point((extraSpaceX == 0 ? 0 : -(this.tileBounds.getWidth() - extraSpaceX)) - this.tileBounds.getHalfWidth(), (extraSpaceY == 0 ? 0 : -(this.tileBounds.getHalfHeight() - extraSpaceY)) - this.tileBounds.getHalfHeight());
        int visibleTilesX = (this.size.width - this.topLeftVisibleTilePoint.x) / this.tileBounds.getWidth() + ((this.size.width - this.topLeftVisibleTilePoint.x) % this.tileBounds.getWidth() > 0 ? 1 : 0);
        int visibleTilesY = (this.size.height - this.topLeftVisibleTilePoint.y) / this.tileBounds.getHalfHeight() + ((this.size.height - this.topLeftVisibleTilePoint.y) % this.tileBounds.getHalfHeight() > 0 ? 1 : 0);
        this.bottomRightVisibleTile = new Map.Position(this.topLeftVisibleTile.x + visibleTilesX - 1, this.topLeftVisibleTile.y + visibleTilesY - 1);
    }

    Point tileToPoint(Tile tile) {
        int tileX = tile.getX();
        int tileY = tile.getY();
        int x = this.topLeftVisibleTilePoint.x + this.tileBounds.getWidth() * (tileX - this.topLeftVisibleTile.getX()) + (tileY & 1) * this.tileBounds.getHalfWidth();
        int y = this.topLeftVisibleTilePoint.y + this.tileBounds.getHalfHeight() * (tileY - this.topLeftVisibleTile.getY());
        return new Point(x, y);
    }

    public Rectangle calculateDrawnTileBounds(Tile tile) {
        if (!this.isTileVisible(tile)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Point p = this.tileToPoint(tile);
        return new Rectangle(p.x - this.tileBounds.getHalfWidth(), p.y - this.tileBounds.getHeight(), this.tileBounds.getWidth() * 2, this.tileBounds.getHeight() * 2);
    }

    Map.Position getTopLeftVisibleTile() {
        return this.topLeftVisibleTile;
    }

    Point getTopLeftVisibleTilePoint() {
        return this.topLeftVisibleTilePoint;
    }

    Map.Position getBottomRightVisibleTile() {
        return this.bottomRightVisibleTile;
    }

    Dimension getSize() {
        return this.size;
    }

    public Tile getFocus() {
        return this.focus;
    }

    Tile convertToMapTile(Map map, int x, int y) {
        if (map == null || this.focus == null) {
            return null;
        }
        Point p = this.tileToPoint(this.focus);
        int leftOffset = p.x + this.tileBounds.getHalfWidth();
        int topOffset = p.y + this.tileBounds.getHalfHeight();
        int fx = this.focus.getX();
        int fy = this.focus.getY();
        int dcol = (x - leftOffset + (x > leftOffset ? this.tileBounds.getHalfWidth() : -this.tileBounds.getHalfWidth())) / this.tileBounds.getWidth();
        int drow = (y - topOffset + (y > topOffset ? this.tileBounds.getHalfHeight() : -this.tileBounds.getHalfHeight())) / this.tileBounds.getHeight();
        int px = leftOffset + dcol * this.tileBounds.getWidth();
        int py = topOffset + drow * this.tileBounds.getHeight();
        int newCol = fx + dcol;
        int newRow = fy + drow * 2;
        Direction direction = null;
        if (x > px) {
            if (y > py) {
                if (y - py > this.tileBounds.getHalfHeight() - (x - px) / 2) {
                    direction = Direction.SE;
                }
            } else if (y - py < (x - px) / 2 - this.tileBounds.getHalfHeight()) {
                direction = Direction.NE;
            }
        } else if (y > py) {
            if (y - py > (x - px) / 2 + this.tileBounds.getHalfHeight()) {
                direction = Direction.SW;
            }
        } else if (y - py < (px - x) / 2 - this.tileBounds.getHalfHeight()) {
            direction = Direction.NW;
        }
        int col = newCol;
        int row = newRow;
        if (direction != null) {
            Map.Position step = direction.step(newCol, newRow);
            col = step.x;
            row = step.y;
        }
        return map.getTile(col, row);
    }

    void changeSize(Dimension size, TileBounds tileBounds) {
        this.size = size;
        this.updateSizeVariables(tileBounds);
    }

    boolean isTileVisible(Tile tile) {
        if (tile == null) {
            return false;
        }
        return tile.getX() >= this.topLeftVisibleTile.getX() && tile.getX() <= this.bottomRightVisibleTile.getX() && tile.getY() >= this.topLeftVisibleTile.getY() && tile.getY() <= this.bottomRightVisibleTile.getY();
    }

    TileBounds getTileBounds() {
        return this.tileBounds;
    }

    public void resetScrollSpeed() {
        this.scrollSpeed = 1;
    }
}

