/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportContinentalCongressPanel
extends ReportPanel {
    private static final String none = Messages.message("report.continentalCongress.none");

    public ReportContinentalCongressPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportCongressAction");
        JTabbedPane tabs = new JTabbedPane(1);
        tabs.setOpaque(false);
        Player player = this.getMyPlayer();
        FoundingFather currentFather = player.getCurrentFather();
        MigPanel recruitingPanel = new MigPanel(new MigLayout("center, wrap 1", "center"));
        if (currentFather == null) {
            recruitingPanel.add((Component)new JLabel(none), "wrap 20");
        } else {
            String name = Messages.getName(currentFather);
            FoundingFather.FoundingFatherType[] button = Utility.getLinkButton(name, null, currentFather.getId());
            button.addActionListener(this);
            recruitingPanel.add((Component)button);
            JLabel currentFatherLabel = new JLabel(new ImageIcon(this.getImageLibrary().getFoundingFatherImage(currentFather, false)));
            currentFatherLabel.setToolTipText(Messages.getDescription(currentFather));
            recruitingPanel.add(currentFatherLabel);
            for (GoodsType gt : this.getSpecification().getLibertyGoodsTypeList()) {
                int total = CollectionUtils.sum(player.getColonies(), c -> c.getNetProductionOf(gt));
                FreeColProgressBar progressBar = new FreeColProgressBar(freeColClient, gt, 0, player.getTotalFoundingFatherCost(), player.getLiberty(), total);
                recruitingPanel.add((Component)progressBar, "wrap 20");
            }
        }
        tabs.addTab(Messages.message("report.continentalCongress.recruiting"), null, recruitingPanel, null);
        EnumMap<FoundingFather.FoundingFatherType, MigPanel> panels = new EnumMap<FoundingFather.FoundingFatherType, MigPanel>(FoundingFather.FoundingFatherType.class);
        for (FoundingFather.FoundingFatherType type : FoundingFather.FoundingFatherType.values()) {
            MigPanel panel = new MigPanel(new MigLayout("flowy", "[center]"));
            panels.put(type, panel);
            JScrollPane imageScrollPane = new JScrollPane(panel, 20, 30);
            tabs.addTab(Messages.message(type.getTypeKey()), null, imageScrollPane, null);
        }
        int age = this.getGame().getAge();
        Map<String, Turn> electionTurns = this.getMyPlayer().getElectionTurns();
        for (FoundingFather father : this.getSpecification().getFoundingFathers()) {
            BufferedImage image;
            JPanel panel = (JPanel)panels.get((Object)father.getType());
            Turn turn = null;
            if (player.hasFather(father)) {
                image = this.getImageLibrary().getFoundingFatherImage(father, false);
                turn = electionTurns.get(Messages.nameKey(father));
            } else {
                image = this.getImageLibrary().getFoundingFatherImage(father, true);
            }
            panel.add((Component)new JLabel(new ImageIcon(image)), "newline");
            JButton button = Utility.getLinkButton(Messages.getName(father), null, father.getId());
            button.addActionListener(this);
            panel.add(button);
            panel.add(turn != null ? Utility.localizedLabel(StringTemplate.template("report.continentalCongress.elected").addStringTemplate("%turn%", turn.getLabel())) : (father == currentFather ? Utility.localizedLabel("report.continentalCongress.recruiting") : Utility.localizedLabel("report.continentalCongress.available")));
            if (!FreeColDebugger.isInDebugMode(FreeColDebugger.DebugMode.MENUS)) continue;
            panel.add(new JLabel(String.valueOf(father.getWeight(age))));
        }
        panels.clear();
        this.setMainComponent(tabs);
    }
}

