/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class ClaimLandMessage
extends AttributeMessage {
    public static final String TAG = "claimLand";
    private static final String CLAIMANT_TAG = "claimant";
    private static final String PRICE_TAG = "price";
    private static final String TILE_TAG = "tile";

    public ClaimLandMessage(Tile tile, FreeColGameObject claimant, int price) {
        super(TAG, TILE_TAG, tile.getId(), CLAIMANT_TAG, claimant.getId(), PRICE_TAG, String.valueOf(price));
    }

    public ClaimLandMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, TILE_TAG, CLAIMANT_TAG, PRICE_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        int price;
        ServerGame game = freeColServer.getGame();
        String tileId = this.getStringAttribute(TILE_TAG);
        String claimantId = this.getStringAttribute(CLAIMANT_TAG);
        String priceString = this.getStringAttribute(PRICE_TAG);
        Tile tile = game.getFreeColGameObject(tileId, Tile.class);
        if (tile == null) {
            return serverPlayer.clientError("Not a file: " + tileId);
        }
        Class c = FreeColObject.getFreeColObjectClassByName(FreeColObject.getIdTypeByName(claimantId));
        Unit unit = null;
        Settlement settlement = null;
        if (Unit.class.isAssignableFrom(c)) {
            unit = serverPlayer.getOurFreeColGameObject(claimantId, Unit.class);
            if (unit.getTile() != tile) {
                return serverPlayer.clientError("Unit not at tile: " + tileId);
            }
            if (tile.getOwningSettlement() == null) {
                for (Tile t : tile.getSurroundingTiles(1)) {
                    Colony colony = t.getColony();
                    if (!serverPlayer.owns(colony)) continue;
                    settlement = colony;
                    break;
                }
            }
        } else {
            if (!Settlement.class.isAssignableFrom(c)) return serverPlayer.clientError("Not a unit or settlement: " + claimantId);
            settlement = serverPlayer.getOurFreeColGameObject(claimantId, Settlement.class);
            if (settlement.getOwner().isEuropean() && !settlement.getTile().isAdjacent(tile)) {
                return serverPlayer.clientError("Settlement can not claim tile: " + tileId);
            }
        }
        try {
            price = Integer.parseInt(priceString);
        }
        catch (NumberFormatException e) {
            return serverPlayer.clientError("Bad price: " + priceString);
        }
        int value = serverPlayer.getLandPrice(tile);
        Player owner = tile.getOwner();
        Settlement ownerSettlement = tile.getOwningSettlement();
        if (owner == null) {
            price = 0;
            return this.igc(freeColServer).claimLand(serverPlayer, tile, settlement, price);
        } else if (owner == serverPlayer) {
            if (settlement != null && ownerSettlement != null && tile.isInUse()) {
                return serverPlayer.clientError("Can not claim tile " + tile.getId() + ": already owned.");
            }
            price = 0;
            return this.igc(freeColServer).claimLand(serverPlayer, tile, settlement, price);
        } else if (owner.isEuropean()) {
            if (tile.getOwningSettlement() != null && tile.getOwningSettlement() != settlement) return serverPlayer.clientError("Can not claim tile " + tile.getId() + ": European owners will not sell.");
            price = 0;
            return this.igc(freeColServer).claimLand(serverPlayer, tile, settlement, price);
        } else {
            Player.NoClaimReason why = serverPlayer.canClaimForSettlementReason(tile);
            switch (why) {
                case NONE: {
                    return this.igc(freeColServer).claimLand(serverPlayer, tile, settlement, price);
                }
                case NATIVES: {
                    if (price < 0) return this.igc(freeColServer).claimLand(serverPlayer, tile, settlement, price);
                    if (price < value) {
                        return serverPlayer.clientError("Can not claim tile " + tile.getId() + ": insufficient offer.");
                    }
                    if (serverPlayer.checkGold(price)) return this.igc(freeColServer).claimLand(serverPlayer, tile, settlement, price);
                    return serverPlayer.clientError("Can not pay for tile: " + tile.getId() + ": insufficient funds.");
                }
                default: {
                    return serverPlayer.clientError("Can not claim tile " + tile.getId() + ": " + why);
                }
            }
        }
    }
}

