/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class NativeTradeMessage
extends ObjectMessage {
    public static final String TAG = "nativeTrade";
    private static final String ACTION_TAG = "action";

    public NativeTradeMessage(Unit unit, IndianSettlement is) {
        this(NativeTrade.NativeTradeAction.OPEN, new NativeTrade(unit, is));
    }

    public NativeTradeMessage(NativeTrade.NativeTradeAction action, NativeTrade nt) {
        super(TAG, ACTION_TAG, action.toString());
        this.appendChild(nt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeTradeMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, ACTION_TAG);
        NativeTrade nt = null;
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if (TAG.equals(tag)) {
                    if (nt == null) {
                        nt = xr.readFreeColObject(game, NativeTrade.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else {
                    this.expected(TAG, tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChild(nt);
    }

    private NativeTrade.NativeTradeAction getAction() {
        return this.getEnumAttribute(ACTION_TAG, NativeTrade.NativeTradeAction.class, null);
    }

    private NativeTrade getNativeTrade() {
        return this.getChild(0, NativeTrade.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        NativeTrade nt = this.getNativeTrade();
        NativeTrade.NativeTradeAction action = this.getAction();
        aiPlayer.nativeTradeHandler(action, nt);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        NativeTrade.NativeTradeAction action = this.getAction();
        NativeTrade nt = this.getNativeTrade();
        this.igc(freeColClient).nativeTradeHandler(action, nt);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        NativeTrade nt = this.getNativeTrade();
        if (nt == null) {
            return serverPlayer.clientError("Null native trade");
        }
        Unit unit = nt.getUnit();
        if (unit == null) {
            return serverPlayer.clientError("Null unit");
        }
        if (!unit.hasTile()) {
            return serverPlayer.clientError("Unit not on the map: " + unit.getId());
        }
        IndianSettlement is = nt.getIndianSettlement();
        if (is == null) {
            return serverPlayer.clientError("Null settlement");
        }
        if (!unit.getTile().isAdjacent(is.getTile())) {
            return serverPlayer.clientError("Unit not adjacent to settlement");
        }
        return this.igc(freeColServer).nativeTrade(serverPlayer, this.getAction(), nt);
    }
}

