/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine;

import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.Rule;
import org.w3c.dom.DOMException;

public abstract class RuleGroup {
    protected Rule[] rules = this.createRuleList();
    protected int size;
    protected RuleGroup parent;

    protected RuleGroup() {
    }

    protected Rule[] createRuleList() {
        return new Rule[16];
    }

    abstract short getType();

    public RuleGroup getParent() {
        return this.parent;
    }

    public void setParent(RuleGroup ss) {
        this.parent = ss;
    }

    public int getSize() {
        return this.size;
    }

    public Rule getRule(int i) {
        return this.rules[i];
    }

    public void deleteRule(int index) throws DOMException {
        if (index < 0 || index >= this.size) {
            throw new DOMException(1, "Invalid index: " + index + '.');
        }
        for (int i = index; i < this.size - 1; ++i) {
            this.rules[i] = this.rules[i + 1];
        }
        --this.size;
        this.rules[this.size] = null;
    }

    public void clear() {
        this.size = 0;
        this.rules = new Rule[10];
    }

    public void append(Rule r) {
        if (this.size == this.rules.length) {
            Rule[] t = new Rule[this.size * 2];
            System.arraycopy(this.rules, 0, t, 0, this.size);
            this.rules = t;
        }
        this.rules[this.size++] = r;
    }

    public String toString(CSSEngine eng) {
        StringBuilder sb = new StringBuilder(this.size * 8);
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.rules[i].toString(eng));
        }
        return sb.toString();
    }
}

