/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Locale;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.ECConstants;
import net.i2p.crypto.EncAlgo;
import net.i2p.crypto.x25519.spec.X25519Spec;

public enum EncType {
    ELGAMAL_2048(0, 256, 256, EncAlgo.ELGAMAL, "ElGamal/None/NoPadding", CryptoConstants.I2P_ELGAMAL_2048_SPEC, "0"),
    EC_P256(1, 64, 32, EncAlgo.EC, "EC/None/NoPadding", ECConstants.P256_SPEC, "0.9.38"),
    EC_P384(2, 96, 48, EncAlgo.EC, "EC/None/NoPadding", ECConstants.P384_SPEC, "0.9.38"),
    EC_P521(3, 132, 66, EncAlgo.EC, "EC/None/NoPadding", ECConstants.P521_SPEC, "0.9.38"),
    ECIES_X25519(4, 32, 32, EncAlgo.ECIES, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.38"),
    MLKEM512_X25519(5, 32, 32, EncAlgo.ECIES_MLKEM, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM768_X25519(6, 32, 32, EncAlgo.ECIES_MLKEM, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM1024_X25519(7, 32, 32, EncAlgo.ECIES_MLKEM, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM512_X25519_INT(100005, 800, 1632, EncAlgo.ECIES_MLKEM_INT, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM768_X25519_INT(100006, 1184, 2400, EncAlgo.ECIES_MLKEM_INT, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM1024_X25519_INT(100007, 1568, 3168, EncAlgo.ECIES_MLKEM_INT, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM512_X25519_CT(100008, 768, 0, EncAlgo.ECIES_MLKEM_INT, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM768_X25519_CT(100009, 1088, 0, EncAlgo.ECIES_MLKEM_INT, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67"),
    MLKEM1024_X25519_CT(100010, 1568, 0, EncAlgo.ECIES_MLKEM_INT, "EC/None/NoPadding", X25519Spec.X25519_SPEC, "0.9.67");

    private final int code;
    private final int pubkeyLen;
    private final int privkeyLen;
    private final EncAlgo base;
    private final String algoName;
    private final String since;
    private final AlgorithmParameterSpec params;
    private final boolean isAvail;
    private final boolean isPQ;
    private static final EncType[] BY_CODE;

    private EncType(int cod, int pubLen, int privLen, EncAlgo baseAlgo, String transformation, AlgorithmParameterSpec pSpec, String supportedSince) {
        if (pubLen > 256 && baseAlgo != EncAlgo.ECIES_MLKEM_INT) {
            throw new IllegalArgumentException("fixup PublicKey for longer keys");
        }
        this.code = cod;
        this.pubkeyLen = pubLen;
        this.privkeyLen = privLen;
        this.base = baseAlgo;
        this.algoName = transformation;
        this.params = pSpec;
        this.since = supportedSince;
        this.isAvail = this.x_isAvailable();
        this.isPQ = this.base == EncAlgo.ECIES_MLKEM;
    }

    public int getCode() {
        return this.code;
    }

    public int getPubkeyLen() {
        return this.pubkeyLen;
    }

    public int getPrivkeyLen() {
        return this.privkeyLen;
    }

    public EncAlgo getBaseAlgorithm() {
        return this.base;
    }

    public String getAlgorithmName() {
        return this.algoName;
    }

    public AlgorithmParameterSpec getParams() throws InvalidParameterSpecException {
        if (this.params == null) {
            throw new InvalidParameterSpecException(this.toString() + " is not available in this JVM");
        }
        return this.params;
    }

    public String getSupportedSince() {
        return this.since;
    }

    public boolean isAvailable() {
        return this.isAvail;
    }

    private boolean x_isAvailable() {
        switch (this.base) {
            case ELGAMAL: {
                return true;
            }
            case EC: 
            case ECIES_MLKEM_INT: {
                return false;
            }
        }
        try {
            this.getParams();
        }
        catch (InvalidParameterSpecException e) {
            return false;
        }
        return true;
    }

    public static boolean isAvailable(int code) {
        EncType type = EncType.getByCode(code);
        if (type == null) {
            return false;
        }
        return type.isAvailable();
    }

    public static boolean isAvailable(String stype) {
        EncType type = EncType.parseEncType(stype);
        if (type == null) {
            return false;
        }
        return type.isAvailable();
    }

    public boolean isPQ() {
        return this.isPQ;
    }

    public static EncType getByCode(int code) {
        if (code < 0 || code >= BY_CODE.length) {
            return null;
        }
        return BY_CODE[code];
    }

    public static EncType parseEncType(String stype) {
        try {
            String uc = stype.toUpperCase(Locale.US);
            return EncType.valueOf(uc);
        }
        catch (IllegalArgumentException iae) {
            try {
                int code = Integer.parseInt(stype);
                return EncType.getByCode(code);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }

    static {
        EncType[] values = EncType.values();
        int max = values[values.length - 1].getCode();
        BY_CODE = new EncType[max + 1];
        for (EncType type : values) {
            int i = type.getCode();
            if (BY_CODE[i] != null) {
                throw new IllegalStateException("Duplicate EncType code");
            }
            EncType.BY_CODE[i] = type;
        }
    }
}

