/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization;

import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import com.intellij.platform.runtime.repository.impl.RuntimeModuleRepositoryImpl;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleRepositoryData;
import com.intellij.platform.runtime.repository.serialization.impl.CompactFileReader;
import com.intellij.platform.runtime.repository.serialization.impl.CompactFileWriter;
import com.intellij.platform.runtime.repository.serialization.impl.JarFileSerializer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RuntimeModuleRepositorySerialization {
    private RuntimeModuleRepositorySerialization() {
    }

    public static void saveToCompactFile(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path filePath, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(1);
        }
        RuntimeModuleRepositorySerialization.saveToCompactFile(descriptors, bootstrapModuleName, filePath, null, generatorVersion);
    }

    public static void saveToCompactFile(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path filePath, @Nullable String mainPluginModuleId, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(3);
        }
        CompactFileWriter.saveToFile(descriptors, bootstrapModuleName, mainPluginModuleId, generatorVersion, filePath);
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarPath, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(4);
        }
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(5);
        }
        RuntimeModuleRepositorySerialization.saveToJar(descriptors, bootstrapModuleName, jarPath, null, generatorVersion);
    }

    public static void saveToJar(@NotNull Collection<RawRuntimeModuleDescriptor> descriptors, @Nullable String bootstrapModuleName, @NotNull Path jarPath, @Nullable String mainPluginModuleId, int generatorVersion) throws IOException {
        if (descriptors == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(6);
        }
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(7);
        }
        try {
            JarFileSerializer.saveToJar(descriptors, bootstrapModuleName, jarPath, mainPluginModuleId, generatorVersion);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public static RawRuntimeModuleRepositoryData loadFromCompactFile(@NotNull Path filePath) throws MalformedRepositoryException {
        RawRuntimeModuleRepositoryData rawRuntimeModuleRepositoryData;
        if (filePath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(8);
        }
        try {
            rawRuntimeModuleRepositoryData = CompactFileReader.loadFromFile(filePath);
        }
        catch (IOException e) {
            throw new MalformedRepositoryException("Failed to load repository from " + String.valueOf(filePath), e);
        }
        if (rawRuntimeModuleRepositoryData == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(9);
        }
        return rawRuntimeModuleRepositoryData;
    }

    @NotNull
    public static RawRuntimeModuleRepositoryData loadFromJar(@NotNull Path jarPath) throws MalformedRepositoryException {
        RawRuntimeModuleRepositoryData rawRuntimeModuleRepositoryData;
        if (jarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(10);
        }
        try {
            rawRuntimeModuleRepositoryData = JarFileSerializer.loadFromJar(jarPath);
        }
        catch (IOException | XMLStreamException e) {
            throw new MalformedRepositoryException("Failed to load repository from " + String.valueOf(jarPath), e);
        }
        if (rawRuntimeModuleRepositoryData == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(11);
        }
        return rawRuntimeModuleRepositoryData;
    }

    @NotNull
    public static RuntimeModuleRepository loadFromRawData(@NotNull Path descriptorsJarPath, @NotNull RawRuntimeModuleRepositoryData rawRuntimeModuleRepositoryData) {
        if (descriptorsJarPath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(12);
        }
        if (rawRuntimeModuleRepositoryData == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(13);
        }
        return new RuntimeModuleRepositoryImpl(descriptorsJarPath, rawRuntimeModuleRepositoryData);
    }

    @ApiStatus.Internal
    @Nullable
    public static Path getFallbackJarPath(@NotNull Path descriptorsFilePath) {
        if (descriptorsFilePath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(14);
        }
        if (descriptorsFilePath.getFileName().toString().endsWith(".jar")) {
            return descriptorsFilePath;
        }
        Path jarPath = descriptorsFilePath.getParent().resolve("module-descriptors.jar");
        if (!Files.exists(descriptorsFilePath, new LinkOption[0]) && Files.exists(jarPath, new LinkOption[0])) {
            return jarPath;
        }
        return null;
    }

    public static @NotNull String @Nullable [] loadBootstrapClasspath(@NotNull Path descriptorsFilePath, @NotNull String bootstrapModuleName) throws IOException {
        Path fallbackJarPath;
        if (descriptorsFilePath == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(15);
        }
        if (bootstrapModuleName == null) {
            RuntimeModuleRepositorySerialization.$$$reportNull$$$0(16);
        }
        if ((fallbackJarPath = RuntimeModuleRepositorySerialization.getFallbackJarPath(descriptorsFilePath)) != null) {
            return JarFileSerializer.loadBootstrapClasspath(fallbackJarPath, bootstrapModuleName);
        }
        return CompactFileReader.loadBootstrapClasspath(descriptorsFilePath, bootstrapModuleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarPath";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/repository/serialization/RuntimeModuleRepositorySerialization";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsJarPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawRuntimeModuleRepositoryData";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorsFilePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootstrapModuleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/repository/serialization/RuntimeModuleRepositorySerialization";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromCompactFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveToCompactFile";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveToJar";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadFromCompactFile";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadFromJar";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadFromRawData";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackJarPath";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadBootstrapClasspath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

