/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.File;
import java.io.PrintStream;
import java.util.StringTokenizer;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperResources;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

class WrapperNativeLibrary {
    private static boolean m_libraryLoaded = false;
    private static boolean m_libraryOK = false;
    private static String m_libraryName = null;
    private static String m_os = null;
    private static String m_arch = null;
    private static boolean m_windows = false;
    private static boolean m_macosx = false;
    private static boolean m_aix = false;
    private static boolean m_zos = false;
    private static PrintStream m_outInfo = System.out;
    private static PrintStream m_outError = System.out;
    private static PrintStream m_outDebug = System.out;
    private static WrapperResources m_res = null;
    private static boolean m_professionalEdition;
    private static boolean m_standardEdition;

    WrapperNativeLibrary() {
    }

    private static native void nativeInit(boolean var0);

    private static native void nativeDispose(boolean var0);

    private static native String nativeGetLibraryPath(boolean var0) throws NullPointerException;

    private static native String nativeGetLibraryVersion();

    private static native boolean nativeIsProfessionalEdition();

    private static native boolean nativeIsStandardEdition();

    private static native WrapperResources nativeLoadWrapperResources(String var0, String var1, boolean var2);

    static void setPrintStreams(PrintStream outInfo, PrintStream outError, PrintStream outDebug) {
        if (outInfo != null) {
            m_outInfo = outInfo;
        }
        if (outError != null) {
            m_outError = outError;
        }
        if (outDebug != null) {
            m_outDebug = outDebug;
        }
    }

    static boolean load(int jvmBits, boolean doInit, boolean debug, boolean errorAsInfo) {
        String baseName = System.getProperty("wrapper.native_library");
        if (baseName == null) {
            m_outInfo.println("WARNING - The wrapper.native_library system property was not");
            m_outInfo.println("          set. Using the default value, 'wrapper'.");
            baseName = "wrapper";
        }
        String[] detailedNames = new String[2];
        if (jvmBits > 0) {
            detailedNames[0] = WrapperNativeLibrary.generateDetailedNativeLibraryBaseName(baseName, jvmBits);
        } else {
            detailedNames[0] = WrapperNativeLibrary.generateDetailedNativeLibraryBaseName(baseName, 32);
            detailedNames[1] = WrapperNativeLibrary.generateDetailedNativeLibraryBaseName(baseName, 64);
        }
        String file = WrapperNativeLibrary.mapSharedLibraryName(baseName);
        String[] detailedFiles = new String[detailedNames.length];
        for (int i = 0; i < detailedNames.length; ++i) {
            if (detailedNames[i] == null) continue;
            detailedFiles[i] = WrapperNativeLibrary.mapSharedLibraryName(detailedNames[i]);
        }
        String[] detailedErrors = new String[detailedNames.length];
        String baseError = null;
        if (debug) {
            m_outDebug.println("Load native library.  There are multiple possible file names and the first to be found will be used.  Errors loading non-existing files is normal and is only a problem if they all fail.");
        }
        for (int i = 0; i < detailedNames.length; ++i) {
            if (detailedNames[i] == null) continue;
            detailedErrors[i] = WrapperNativeLibrary.loadNativeLibrary(detailedNames[i], detailedFiles[i], debug);
            if (detailedErrors[i] != null) continue;
            m_libraryName = detailedFiles[i];
            m_libraryOK = true;
            break;
        }
        if (!m_libraryOK && (baseError = WrapperNativeLibrary.loadNativeLibrary(baseName, file, debug)) == null) {
            m_libraryName = file;
            m_libraryOK = true;
        }
        if (m_libraryOK) {
            m_libraryLoaded = true;
            if (debug) {
                m_outDebug.println("  Successfully loaded native library.");
            }
            try {
                m_professionalEdition = WrapperNativeLibrary.nativeIsProfessionalEdition();
            }
            catch (Throwable e) {
                if (debug) {
                    m_outDebug.println("Call to nativeIsProfessionalEdition() failed: " + e);
                }
                m_professionalEdition = false;
            }
            try {
                m_standardEdition = WrapperNativeLibrary.nativeIsStandardEdition();
            }
            catch (Throwable e) {
                if (debug) {
                    m_outDebug.println("Call to nativeIsStandardEdition() failed: " + e);
                }
                m_standardEdition = false;
            }
            m_res = WrapperNativeLibrary.loadWrapperResourcesInner(System.getProperty("wrapper.lang.domain") + "jni", WrapperSystemPropertyUtil.getStringProperty("wrapper.lang.folder", "../lang"), true);
            if (debug) {
                m_outDebug.println(WrapperNativeLibrary.getRes().getString("Loaded localized resources."));
            }
            if (doInit) {
                if (debug) {
                    m_outDebug.println(WrapperNativeLibrary.getRes().getString("Calling native initialization method."));
                }
                WrapperNativeLibrary.nativeInit(debug);
            }
        } else {
            m_libraryLoaded = false;
            PrintStream out = errorAsInfo ? m_outInfo : m_outError;
            out.println();
            String libPath = System.getProperty("java.library.path");
            if (libPath.equals("")) {
                out.println("ERROR - Unable to load the Wrapper's native library because the");
                out.println("        java.library.path was set to ''.  Please see the");
                out.println("        documentation for the wrapper.java.library.path");
                out.println("        configuration property.");
            } else {
                int i;
                String error = null;
                File libFile = null;
                for (i = 0; i < detailedNames.length; ++i) {
                    if (detailedFiles[i] == null || (libFile = WrapperNativeLibrary.locateFileOnPath(detailedFiles[i], libPath)) == null) continue;
                    error = detailedErrors[i];
                    break;
                }
                if (libFile == null && (libFile = WrapperNativeLibrary.locateFileOnPath(file, libPath)) != null) {
                    error = baseError;
                }
                if (libFile == null) {
                    out.println("ERROR - Unable to load the Wrapper's native library because none of the");
                    out.println("        following files:");
                    for (i = 0; i < detailedNames.length; ++i) {
                        if (detailedFiles[i] == null) continue;
                        out.println("          " + detailedFiles[i]);
                    }
                    out.println("          " + file);
                    out.println("        could be located on the following java.library.path:");
                    String pathSep = System.getProperty("path.separator");
                    StringTokenizer st = new StringTokenizer(libPath, pathSep);
                    while (st.hasMoreTokens()) {
                        File pathElement = new File(st.nextToken());
                        out.println("          " + pathElement.getAbsolutePath());
                    }
                    out.println("        Please see the documentation for the wrapper.java.library.path");
                    out.println("        configuration property.");
                } else {
                    out.println("ERROR - Unable to load the Wrapper's native library '" + libFile.getName() + "'.");
                    out.println("        The file is located on the path at the following location but");
                    out.println("        could not be loaded:");
                    out.println("          " + libFile.getAbsolutePath());
                    out.println("        Please verify that the file is both readable and executable by the");
                    out.println("        current user and that the file has not been corrupted in any way.");
                    out.println("        One common cause of this problem is running a 32-bit version");
                    out.println("        of the Wrapper with a 64-bit version of Java, or vice versa.");
                    if (jvmBits > 0) {
                        out.println("        This is a " + jvmBits + "-bit JVM.");
                    } else {
                        out.println("        The bit depth of this JVM could not be determined.");
                    }
                    out.println("        Reported cause:");
                    out.println("          " + error);
                }
            }
            out.println();
        }
        return m_libraryLoaded;
    }

    static void dispose(boolean debug) {
        if (m_libraryOK) {
            WrapperNativeLibrary.nativeDispose(debug);
        }
    }

    static String generateDetailedNativeLibraryBaseName(String baseName, int jvmBits) {
        String os = System.getProperty("os.name", "").toLowerCase();
        if (os.startsWith("windows")) {
            os = "windows";
            m_windows = true;
        } else if (os.equals("sunos")) {
            os = "solaris";
        } else if (os.equals("hp-ux") || os.equals("hp-ux64")) {
            os = "hpux";
        } else if (os.equals("mac os x")) {
            os = "macosx";
            m_macosx = true;
        } else if (os.equals("unix_sv")) {
            os = "unixware";
        } else if (os.equals("os/400")) {
            os = "os400";
        } else if (os.equals("z/os")) {
            os = "zos";
            m_zos = true;
        } else if (os.indexOf("aix") > -1) {
            m_aix = true;
        }
        m_os = os;
        String arch = System.getProperty("os.arch", "").toLowerCase();
        if (m_macosx) {
            if (arch.startsWith("arm") || arch.startsWith("aarch")) {
                arch = "arm";
            } else if (arch.equals("ppc") || arch.equals("ppc64") || arch.equals("x86") || arch.equals("x86_64")) {
                arch = "universal";
            }
        } else if (arch.equals("amd64") || arch.equals("athlon") || arch.equals("x86_64") || arch.equals("i686") || arch.equals("i586") || arch.equals("i486") || arch.equals("i386")) {
            arch = "x86";
        } else if (arch.startsWith("ia32") || arch.startsWith("ia64")) {
            arch = "ia";
        } else if (arch.startsWith("sparc")) {
            arch = "sparc";
        } else if (arch.startsWith("ppc64le")) {
            arch = "ppcle";
        } else if (arch.equals("power") || arch.equals("powerpc") || arch.equals("ppc64")) {
            arch = m_aix ? "ppc" : "ppcbe";
        } else if (arch.startsWith("pa_risc") || arch.startsWith("pa-risc")) {
            arch = "parisc";
        } else if (arch.startsWith("arm") || arch.startsWith("aarch")) {
            arch = jvmBits == 64 ? "arm" : System.getProperty("wrapper.arch");
        } else if (arch.equals("s390") || arch.equals("s390x")) {
            arch = "390";
        }
        m_arch = arch;
        return baseName + "-" + os + "-" + arch + "-" + jvmBits;
    }

    private static String mapSharedLibraryName(String name) {
        String result = System.mapLibraryName(name);
        if (WrapperNativeLibrary.isAIX() && result.endsWith(".a")) {
            result = result.substring(0, result.length() - 2).concat(".so");
        }
        if (WrapperNativeLibrary.isMacOSX() && "universal".equalsIgnoreCase(System.getProperty("wrapper.arch")) && result.endsWith(".dylib")) {
            result = result.substring(0, result.length() - 6).concat(".jnilib");
        }
        return result;
    }

    private static String loadNativeLibrary(String name, String file, boolean debug) {
        try {
            WrapperNativeLibrary.checkOldLibraryOnAix(file);
            System.loadLibrary(name);
            if (debug) {
                m_outDebug.println(WrapperNativeLibrary.getRes().getString("  Attempt to load native library with name: {0}  Result: {1}", file, WrapperNativeLibrary.getRes().getString("Success!")));
            }
            return null;
        }
        catch (UnsatisfiedLinkError e) {
            String error;
            if (debug) {
                m_outDebug.println(WrapperNativeLibrary.getRes().getString("  Attempt to load native library with name: {0}  Result: {1}", file, e.getMessage()));
            }
            if ((error = e.getMessage()) == null) {
                error = e.toString();
            }
            return error;
        }
        catch (Throwable e) {
            if (debug) {
                m_outDebug.println(WrapperNativeLibrary.getRes().getString("  Attempt to load native library with name: {0}  Result: {1}", file, e.getMessage()));
            }
            String error = e.toString();
            return error;
        }
    }

    private static void checkOldLibraryOnAix(String libName) {
        if (WrapperNativeLibrary.isAIX()) {
            if (libName.endsWith(".so")) {
                libName = libName.substring(0, libName.length() - 3).concat(".a");
            }
            String pathSep = System.getProperty("path.separator");
            String[] libPaths = System.getProperty("java.library.path").split(pathSep);
            for (int j = 0; j < libPaths.length; ++j) {
                File libFile = WrapperNativeLibrary.locateFileOnPath(libName, libPaths[j]);
                if (libFile == null) continue;
                m_outInfo.println(WrapperNativeLibrary.getRes().getString("WARNING - {0} was found in {1}.", libName, libPaths[j]));
                m_outInfo.println(WrapperNativeLibrary.getRes().getString("          Recent Wrapper''s native libraries have a ''.so'' suffix."));
                m_outInfo.println(WrapperNativeLibrary.getRes().getString("          Depending on the version of Java that is used, {0}", libName));
                m_outInfo.println(WrapperNativeLibrary.getRes().getString("          may be loaded instead of a more recent library."));
                m_outInfo.println(WrapperNativeLibrary.getRes().getString("          Please remove {0} and make sure that the latest version", libName));
                m_outInfo.println(WrapperNativeLibrary.getRes().getString("          of the Wrapper''s native library is in the lib folder."));
            }
        }
    }

    static WrapperResources loadWrapperResourcesInner(String domain, String folder, boolean makeActive) {
        if (m_libraryLoaded && WrapperNativeLibrary.isStandardEdition()) {
            WrapperResources res;
            if (folder == null) {
                folder = WrapperSystemPropertyUtil.getStringProperty("wrapper.lang.folder", "../lang");
            }
            if ((res = WrapperNativeLibrary.nativeLoadWrapperResources(domain, folder, makeActive)) != null) {
                return res;
            }
            return new WrapperResources();
        }
        return new WrapperResources();
    }

    static WrapperResources getRes() {
        if (m_res == null) {
            m_res = new WrapperResources();
        }
        return m_res;
    }

    private static File locateFileOnPath(String file, String path) {
        String pathSep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(path, pathSep);
        while (st.hasMoreTokens()) {
            File libFile = new File(new File(st.nextToken()), file);
            if (!libFile.exists()) continue;
            return libFile;
        }
        return null;
    }

    static boolean isProfessionalEdition() {
        return m_professionalEdition;
    }

    static boolean isStandardEdition() {
        return m_standardEdition;
    }

    static boolean allowsNativeCalls() {
        return m_libraryOK;
    }

    static void disableNativeCalls() {
        m_libraryOK = false;
    }

    static String getVersion(boolean debug) {
        String jniVersion;
        block5: {
            jniVersion = null;
            if (m_libraryOK) {
                try {
                    jniVersion = WrapperNativeLibrary.nativeGetLibraryVersion();
                }
                catch (Throwable e) {
                    try {
                        jniVersion = WrapperManager.nativeGetLibraryVersion();
                    }
                    catch (Exception ex) {
                        if (!debug) break block5;
                        m_outDebug.println(WrapperNativeLibrary.getRes().getString("Call to nativeGetLibraryVersion() failed: {0}", ex));
                    }
                }
            }
        }
        return jniVersion;
    }

    static String getLibraryPath(boolean debug) {
        String jniPath;
        block3: {
            jniPath = null;
            if (m_libraryOK) {
                try {
                    jniPath = WrapperNativeLibrary.nativeGetLibraryPath(debug);
                }
                catch (Throwable e) {
                    if (!debug) break block3;
                    m_outDebug.println(WrapperNativeLibrary.getRes().getString("Call to nativeGetLibraryPath() failed: {0}", e));
                }
            }
        }
        return jniPath;
    }

    static String getOS() {
        return m_os;
    }

    static String getArch() {
        return m_arch;
    }

    static boolean isWindows() {
        return m_windows;
    }

    static boolean isMacOSX() {
        return m_macosx;
    }

    static boolean isAIX() {
        return m_aix;
    }

    static boolean isZOS() {
        return m_zos;
    }
}

