/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.examples.spaceinvaders;

import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.examples.spaceinvaders.AlienEntity;
import org.lwjgl.examples.spaceinvaders.Entity;
import org.lwjgl.examples.spaceinvaders.ShipEntity;
import org.lwjgl.examples.spaceinvaders.ShotEntity;
import org.lwjgl.examples.spaceinvaders.SoundManager;
import org.lwjgl.examples.spaceinvaders.Sprite;
import org.lwjgl.examples.spaceinvaders.TextureLoader;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class Game {
    private String WINDOW_TITLE = "Space Invaders 104 (for LWJGL)";
    private int width = 800;
    private int height = 600;
    private TextureLoader textureLoader;
    private ArrayList<Entity> entities = new ArrayList();
    private ArrayList<Entity> removeList = new ArrayList();
    private ShipEntity ship;
    private ShotEntity[] shots;
    private Sprite message;
    private Sprite pressAnyKey;
    private Sprite youWin;
    private Sprite gotYou;
    private int shotIndex;
    private float moveSpeed = 300.0f;
    private long lastFire;
    private long firingInterval = 500L;
    private int alienCount;
    private boolean waitingForKeyPress = true;
    private boolean logicRequiredThisLoop;
    private long lastLoopTime = Game.getTime();
    private boolean fireHasBeenReleased;
    private long lastFpsTime;
    private int fps;
    private static long timerTicksPerSecond = Sys.getTimerResolution();
    public static boolean gameRunning = true;
    private SoundManager soundManager;
    private boolean fullscreen;
    private int SOUND_SHOT;
    private int SOUND_HIT;
    private int SOUND_START;
    private int SOUND_WIN;
    private int SOUND_LOOSE;
    private int mouseX;
    private static boolean isApplication;

    public Game(boolean fullscreen) {
        this.fullscreen = fullscreen;
        this.initialize();
    }

    public static long getTime() {
        return Sys.getTime() * 1000L / timerTicksPerSecond;
    }

    public static void sleep(long duration) {
        try {
            Thread.sleep(duration * timerTicksPerSecond / 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void initialize() {
        try {
            this.setDisplayMode();
            Display.setTitle((String)this.WINDOW_TITLE);
            Display.setFullscreen((boolean)this.fullscreen);
            Display.create();
            if (isApplication) {
                Mouse.setGrabbed((boolean)true);
            }
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2929);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)this.width, (double)this.height, (double)0.0, (double)-1.0, (double)1.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
            this.textureLoader = new TextureLoader();
            this.soundManager = new SoundManager();
            this.soundManager.initialize(8);
            this.SOUND_SHOT = this.soundManager.addSound("shot.wav");
            this.SOUND_HIT = this.soundManager.addSound("hit.wav");
            this.SOUND_START = this.soundManager.addSound("start.wav");
            this.SOUND_WIN = this.soundManager.addSound("win.wav");
            this.SOUND_LOOSE = this.soundManager.addSound("loose.wav");
        }
        catch (LWJGLException le) {
            System.out.println("Game exiting - exception in initialization:");
            le.printStackTrace();
            gameRunning = false;
            return;
        }
        this.gotYou = this.getSprite("gotyou.gif");
        this.pressAnyKey = this.getSprite("pressanykey.gif");
        this.youWin = this.getSprite("youwin.gif");
        this.message = this.pressAnyKey;
        this.shots = new ShotEntity[5];
        for (int i = 0; i < this.shots.length; ++i) {
            this.shots[i] = new ShotEntity(this, "shot.gif", 0, 0);
        }
        this.startGame();
    }

    private boolean setDisplayMode() {
        try {
            DisplayMode[] dm = org.lwjgl.util.Display.getAvailableDisplayModes((int)this.width, (int)this.height, (int)-1, (int)-1, (int)-1, (int)-1, (int)60, (int)60);
            org.lwjgl.util.Display.setDisplayMode((DisplayMode[])dm, (String[])new String[]{"width=" + this.width, "height=" + this.height, "freq=60", "bpp=" + Display.getDisplayMode().getBitsPerPixel()});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to enter fullscreen, continuing in windowed mode");
            return false;
        }
    }

    private void startGame() {
        this.entities.clear();
        this.initEntities();
    }

    private void initEntities() {
        this.ship = new ShipEntity(this, "ship.gif", 370, 550);
        this.entities.add(this.ship);
        this.alienCount = 0;
        for (int row = 0; row < 5; ++row) {
            for (int x = 0; x < 12; ++x) {
                AlienEntity alien = new AlienEntity(this, 100 + x * 50, 50 + row * 30);
                this.entities.add(alien);
                ++this.alienCount;
            }
        }
    }

    public void updateLogic() {
        this.logicRequiredThisLoop = true;
    }

    public void removeEntity(Entity entity) {
        this.removeList.add(entity);
    }

    public void notifyDeath() {
        if (!this.waitingForKeyPress) {
            this.soundManager.playSound(this.SOUND_LOOSE);
        }
        this.message = this.gotYou;
        this.waitingForKeyPress = true;
    }

    public void notifyWin() {
        this.message = this.youWin;
        this.waitingForKeyPress = true;
        this.soundManager.playSound(this.SOUND_WIN);
    }

    public void notifyAlienKilled() {
        --this.alienCount;
        if (this.alienCount == 0) {
            this.notifyWin();
        }
        for (Entity entity : this.entities) {
            if (!(entity instanceof AlienEntity)) continue;
            entity.setHorizontalMovement(entity.getHorizontalMovement() * 1.02f);
        }
        this.soundManager.playEffect(this.SOUND_HIT);
    }

    public void tryToFire() {
        if (System.currentTimeMillis() - this.lastFire < this.firingInterval) {
            return;
        }
        this.lastFire = System.currentTimeMillis();
        ShotEntity shot = this.shots[this.shotIndex++ % this.shots.length];
        shot.reinitialize(this.ship.getX() + 10, this.ship.getY() - 30);
        this.entities.add(shot);
        this.soundManager.playEffect(this.SOUND_SHOT);
    }

    private void gameLoop() {
        while (gameRunning) {
            GL11.glClear((int)16640);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            this.frameRendering();
            Display.update();
        }
        this.soundManager.destroy();
        Display.destroy();
    }

    public void frameRendering() {
        Display.sync((int)60);
        long delta = Game.getTime() - this.lastLoopTime;
        this.lastLoopTime = Game.getTime();
        this.lastFpsTime += delta;
        ++this.fps;
        if (this.lastFpsTime >= 1000L) {
            Display.setTitle((String)(this.WINDOW_TITLE + " (FPS: " + this.fps + ")"));
            this.lastFpsTime = 0L;
            this.fps = 0;
        }
        if (!this.waitingForKeyPress && !this.soundManager.isPlayingSound()) {
            for (Entity entity : this.entities) {
                entity.move(delta);
            }
        }
        for (Entity entity : this.entities) {
            entity.draw();
        }
        for (int p = 0; p < this.entities.size(); ++p) {
            for (int s = p + 1; s < this.entities.size(); ++s) {
                Entity him;
                Entity me = this.entities.get(p);
                if (!me.collidesWith(him = this.entities.get(s))) continue;
                me.collidedWith(him);
                him.collidedWith(me);
            }
        }
        this.entities.removeAll(this.removeList);
        this.removeList.clear();
        if (this.logicRequiredThisLoop) {
            for (Entity entity : this.entities) {
                entity.doLogic();
            }
            this.logicRequiredThisLoop = false;
        }
        if (this.waitingForKeyPress) {
            this.message.draw(325, 250);
        }
        this.ship.setHorizontalMovement(0.0f);
        this.mouseX = Mouse.getDX();
        boolean leftPressed = this.hasInput(203);
        boolean rightPressed = this.hasInput(205);
        boolean firePressed = this.hasInput(57);
        if (!this.waitingForKeyPress && !this.soundManager.isPlayingSound()) {
            if (leftPressed && !rightPressed) {
                this.ship.setHorizontalMovement(-this.moveSpeed);
            } else if (rightPressed && !leftPressed) {
                this.ship.setHorizontalMovement(this.moveSpeed);
            }
            if (firePressed) {
                this.tryToFire();
            }
        } else {
            if (!firePressed) {
                this.fireHasBeenReleased = true;
            }
            if (firePressed && this.fireHasBeenReleased && !this.soundManager.isPlayingSound()) {
                this.waitingForKeyPress = false;
                this.fireHasBeenReleased = false;
                this.startGame();
                this.soundManager.playSound(this.SOUND_START);
            }
        }
        if ((Display.isCloseRequested() || Keyboard.isKeyDown((int)1)) && isApplication) {
            gameRunning = false;
        }
    }

    private boolean hasInput(int direction) {
        switch (direction) {
            case 203: {
                return Keyboard.isKeyDown((int)203) || this.mouseX < 0;
            }
            case 205: {
                return Keyboard.isKeyDown((int)205) || this.mouseX > 0;
            }
            case 57: {
                return Keyboard.isKeyDown((int)57) || Mouse.isButtonDown((int)0);
            }
        }
        return false;
    }

    public static void main(String[] argv) {
        isApplication = true;
        System.out.println("Use -fullscreen for fullscreen mode");
        new Game(argv.length > 0 && "-fullscreen".equalsIgnoreCase(argv[0])).execute();
        System.exit(0);
    }

    public void execute() {
        this.gameLoop();
    }

    public Sprite getSprite(String ref) {
        return new Sprite(this.textureLoader, ref);
    }
}

