/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.pbuffers;

import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Pbuffer;

abstract class TextureRenderer {
    protected final int width;
    protected final int height;
    private final int texID;
    protected Pbuffer pbuffer;

    protected TextureRenderer(int width, int height, int texID) {
        this.width = width;
        this.height = height;
        this.texID = texID;
        try {
            this.pbuffer = this.init(width, height, texID);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    protected abstract Pbuffer init(int var1, int var2, int var3) throws LWJGLException;

    void enable() {
        try {
            if (this.pbuffer.isBufferLost()) {
                System.out.println("Buffer contents lost - recreating the pbuffer");
                this.pbuffer.destroy();
                this.pbuffer = this.init(this.width, this.height, this.texID);
            }
            this.pbuffer.makeCurrent();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    abstract void updateTexture();

    final void destroy() {
        this.pbuffer.destroy();
    }
}

