/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Condition;
import org.openhab.core.automation.Module;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.Visibility;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.Configuration;

@NonNullByDefault
public class RuleImpl
implements Rule {
    protected List<Trigger> triggers;
    protected List<Condition> conditions;
    protected List<Action> actions;
    protected Configuration configuration;
    protected List<ConfigDescriptionParameter> configDescriptions;
    protected @Nullable String templateUID;
    protected Rule.TemplateState templateStatus;
    protected String uid;
    protected @Nullable String name;
    protected Set<String> tags;
    protected Visibility visibility;
    protected @Nullable String description;

    public RuleImpl(@Nullable String uid) {
        this(uid, null, null, null, null, null, null, null, null, null, Rule.TemplateState.NO_TEMPLATE, null);
    }

    public RuleImpl(@Nullable String uid, @Nullable String name, @Nullable String description, @Nullable Set<String> tags, @Nullable List<Trigger> triggers, @Nullable List<Condition> conditions, @Nullable List<Action> actions, @Nullable List<ConfigDescriptionParameter> configDescriptions, @Nullable Configuration configuration, @Nullable String templateUID, Rule.TemplateState templateStatus, @Nullable Visibility visibility) {
        this.uid = uid == null ? UUID.randomUUID().toString() : uid;
        this.name = name;
        this.description = description;
        this.tags = tags == null ? Set.of() : Set.copyOf(tags);
        this.triggers = triggers == null ? List.of() : List.copyOf(triggers);
        this.conditions = conditions == null ? List.of() : List.copyOf(conditions);
        this.actions = actions == null ? List.of() : List.copyOf(actions);
        this.configDescriptions = configDescriptions == null ? List.of() : List.copyOf(configDescriptions);
        this.configuration = configuration == null ? new Configuration() : new Configuration(configuration.getProperties());
        this.templateUID = templateUID;
        this.templateStatus = templateStatus;
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public @Nullable String getTemplateUID() {
        return this.templateUID;
    }

    public void setTemplateUID(@Nullable String templateUID) {
        this.templateUID = templateUID;
    }

    @Override
    public Rule.TemplateState getTemplateState() {
        return this.templateStatus;
    }

    public void setTemplateStatus(Rule.TemplateState templateState) {
        this.templateStatus = Objects.requireNonNull(templateState);
    }

    @Override
    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String ruleName) {
        this.name = ruleName;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nullable Set<String> ruleTags) {
        this.tags = ruleTags == null ? Set.of() : Collections.unmodifiableSet(ruleTags);
    }

    @Override
    public @Nullable String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String ruleDescription) {
        this.description = ruleDescription;
    }

    @Override
    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(@Nullable Visibility visibility) {
        this.visibility = visibility == null ? Visibility.VISIBLE : visibility;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(@Nullable Configuration ruleConfiguration) {
        this.configuration = ruleConfiguration == null ? new Configuration() : ruleConfiguration;
    }

    @Override
    public List<ConfigDescriptionParameter> getConfigurationDescriptions() {
        return this.configDescriptions;
    }

    public void setConfigurationDescriptions(@Nullable List<ConfigDescriptionParameter> configDescriptions) {
        this.configDescriptions = configDescriptions == null ? List.of() : Collections.unmodifiableList(configDescriptions);
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<Condition> conditions) {
        this.conditions = conditions == null ? List.of() : Collections.unmodifiableList(conditions);
    }

    @Override
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public void setActions(@Nullable List<Action> actions) {
        this.actions = actions == null ? List.of() : Collections.unmodifiableList(actions);
    }

    public void setTriggers(@Nullable List<Trigger> triggers) {
        this.triggers = triggers == null ? List.of() : Collections.unmodifiableList(triggers);
    }

    @Override
    public List<Module> getModules() {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.addAll(this.triggers);
        modules.addAll(this.conditions);
        modules.addAll(this.actions);
        return Collections.unmodifiableList(modules);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.uid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleImpl)) {
            return false;
        }
        RuleImpl other = (RuleImpl)obj;
        return this.uid.equals(other.uid);
    }
}

