/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.persistence.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.AbstractRegistry;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.ManagedProvider;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.persistence.registry.ManagedPersistenceServiceConfigurationProvider;
import org.openhab.core.persistence.registry.PersistenceServiceConfiguration;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationProvider;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationRegistry;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationRegistryChangeListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={PersistenceServiceConfigurationRegistry.class})
public class PersistenceServiceConfigurationRegistryImpl
extends AbstractRegistry<PersistenceServiceConfiguration, String, PersistenceServiceConfigurationProvider>
implements PersistenceServiceConfigurationRegistry {
    private final Logger logger = LoggerFactory.getLogger(PersistenceServiceConfigurationRegistryImpl.class);
    private final Map<String, Provider<PersistenceServiceConfiguration>> serviceToProvider = new HashMap<String, Provider<PersistenceServiceConfiguration>>();
    private final Set<PersistenceServiceConfigurationRegistryChangeListener> registryChangeListeners = new CopyOnWriteArraySet<PersistenceServiceConfigurationRegistryChangeListener>();

    public PersistenceServiceConfigurationRegistryImpl() {
        super(PersistenceServiceConfigurationProvider.class);
    }

    public void added(Provider<PersistenceServiceConfiguration> provider, PersistenceServiceConfiguration element) {
        if (this.serviceToProvider.containsKey(element.getUID())) {
            this.logger.warn("Tried to add strategy container with serviceId '{}', but it was already added before.", (Object)element.getUID());
        } else {
            super.added(provider, (Identifiable)element);
        }
    }

    public void removed(Provider<PersistenceServiceConfiguration> provider, PersistenceServiceConfiguration element) {
        if (!provider.equals(this.serviceToProvider.getOrDefault(element.getUID(), provider))) {
            this.logger.warn("Tried to remove strategy container with serviceId '{}', but it was added by another provider.", (Object)element.getUID());
        } else {
            super.removed(provider, (Identifiable)element);
        }
    }

    public void updated(Provider<PersistenceServiceConfiguration> provider, PersistenceServiceConfiguration oldelement, PersistenceServiceConfiguration element) {
        if (!provider.equals(this.serviceToProvider.getOrDefault(element.getUID(), provider))) {
            this.logger.warn("Tried to update strategy container with serviceId '{}', but it was added by another provider.", (Object)element.getUID());
        } else {
            super.updated(provider, (Identifiable)oldelement, (Identifiable)element);
        }
    }

    protected void notifyListenersAboutAddedElement(PersistenceServiceConfiguration element) {
        this.registryChangeListeners.forEach(listener -> listener.added(element));
        super.notifyListenersAboutAddedElement((Identifiable)element);
    }

    protected void notifyListenersAboutRemovedElement(PersistenceServiceConfiguration element) {
        this.registryChangeListeners.forEach(listener -> listener.removed(element));
        super.notifyListenersAboutRemovedElement((Identifiable)element);
    }

    protected void notifyListenersAboutUpdatedElement(PersistenceServiceConfiguration oldElement, PersistenceServiceConfiguration element) {
        this.registryChangeListeners.forEach(listener -> listener.updated(oldElement, element));
    }

    @Override
    public void addRegistryChangeListener(PersistenceServiceConfigurationRegistryChangeListener listener) {
        this.registryChangeListeners.add(listener);
    }

    @Override
    public void removeRegistryChangeListener(PersistenceServiceConfigurationRegistryChangeListener listener) {
        this.registryChangeListeners.remove(listener);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedProvider(ManagedPersistenceServiceConfigurationProvider provider) {
        super.setManagedProvider((ManagedProvider)provider);
    }

    protected void unsetManagedProvider(ManagedPersistenceServiceConfigurationProvider provider) {
        super.unsetManagedProvider((ManagedProvider)provider);
    }
}

