/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack.congestioncontrol;

public class Rto {
    private static final double ALPHA = 0.25;
    private static final double BETA = 0.125;
    private static final int G = 100;
    private final int kFactor;
    private boolean init;
    private long rto;
    private long rtt;
    private long rttVar;

    public Rto(int kFactor, long ackTimeout) {
        this.kFactor = kFactor;
        this.rtt = 0L;
        this.rttVar = 0L;
        this.rto = ackTimeout;
    }

    public long apply(long measuredRTT) {
        long RTT;
        long RTTVAR;
        if (this.init) {
            RTTVAR = Math.round(0.875 * (double)this.rttVar + 0.125 * (double)Math.abs(this.rtt - measuredRTT));
            RTT = Math.round(0.75 * (double)this.rtt + 0.25 * (double)measuredRTT);
        } else {
            this.init = true;
            RTTVAR = measuredRTT / 2L;
            RTT = measuredRTT;
        }
        this.rtt = RTT;
        this.rttVar = RTTVAR;
        this.rto = RTT + Math.max(100L, (long)this.kFactor * RTTVAR);
        return this.rto;
    }

    public long getRto() {
        return this.rto;
    }

    public long getRtt() {
        return this.rtt;
    }

    public long getRttVar() {
        return this.rttVar;
    }
}

