/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.impl;

import de.focus_shift.jollyday.core.Holiday;
import de.focus_shift.jollyday.core.parser.HolidayParser;
import de.focus_shift.jollyday.core.parser.functions.CreateHoliday;
import de.focus_shift.jollyday.core.parser.functions.FixedToLocalDate;
import de.focus_shift.jollyday.core.parser.functions.MoveDateRelative;
import de.focus_shift.jollyday.core.parser.impl.DescribedDateHolder;
import de.focus_shift.jollyday.core.parser.predicates.ValidLimitation;
import de.focus_shift.jollyday.core.spi.Described;
import de.focus_shift.jollyday.core.spi.Fixed;
import de.focus_shift.jollyday.core.spi.Holidays;
import de.focus_shift.jollyday.core.spi.Movable;
import java.time.LocalDate;
import java.time.Year;
import java.util.List;
import java.util.stream.Collectors;

public class FixedParser
implements HolidayParser {
    @Override
    public List<Holiday> parse(Year year, Holidays holidays) {
        return holidays.fixed().stream().filter(new ValidLimitation(year)).map(fixedConfiguration -> {
            LocalDate actualDate = new FixedToLocalDate(year).apply((Fixed)fixedConfiguration);
            LocalDate observedDate = new MoveDateRelative(actualDate).apply((Movable)fixedConfiguration).orElse(null);
            return new DescribedDateHolder((Described)fixedConfiguration, actualDate, observedDate);
        }).map(describedDateHolder -> new CreateHoliday(describedDateHolder.getActualDate(), describedDateHolder.getObservedDate()).apply(describedDateHolder.getDescribed())).collect(Collectors.toList());
    }
}

