/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.rest.core.internal.discovery;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.stream.Stream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.discovery.DiscoveryResultFlag;
import org.openhab.core.config.discovery.dto.DiscoveryResultDTO;
import org.openhab.core.config.discovery.dto.DiscoveryResultDTOMapper;
import org.openhab.core.config.discovery.inbox.Inbox;
import org.openhab.core.io.rest.JSONResponse;
import org.openhab.core.io.rest.RESTResource;
import org.openhab.core.io.rest.Stream2JSONInputStream;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JSONRequired;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsApplicationSelect;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsName;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="inbox")
@RolesAllowed(value={"administrator"})
@SecurityRequirement(name="oauth2", scopes={"admin"})
@Tag(name="inbox")
@Component(service={RESTResource.class, InboxResource.class})
@JaxrsResource
@JaxrsName(value="inbox")
@JaxrsApplicationSelect(value="(osgi.jaxrs.name=openhab)")
@JSONRequired
@NonNullByDefault
public class InboxResource
implements RESTResource {
    private final Logger logger = LoggerFactory.getLogger(InboxResource.class);
    public static final String PATH_INBOX = "inbox";
    private final Inbox inbox;

    @Activate
    public InboxResource(@Reference Inbox inbox) {
        this.inbox = inbox;
    }

    @POST
    @Path(value="/{thingUID}/approve")
    @Consumes(value={"text/plain"})
    @Operation(operationId="approveInboxItemById", summary="Approves the discovery result by adding the thing to the registry.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", description="Invalid new thing ID."), @ApiResponse(responseCode="404", description="Thing unable to be approved."), @ApiResponse(responseCode="409", description="No binding found that supports this thing.")})
    public Response approve(@HeaderParam(value="Accept-Language") @Parameter(description="language") @Nullable String language, @PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID, @Parameter(description="thing label") @Nullable String label, @QueryParam(value="newThingId") @Parameter(description="new thing ID") @Nullable String newThingId) {
        Thing thing;
        ThingUID thingUIDObject = new ThingUID(thingUID);
        String notEmptyLabel = label != null && !label.isEmpty() ? label : null;
        String notEmptyNewThingId = newThingId != null && !newThingId.isEmpty() ? newThingId : null;
        try {
            thing = this.inbox.approve(thingUIDObject, notEmptyLabel, notEmptyNewThingId);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Thing {} unable to be approved: {}", (Object)thingUID, (Object)e.getLocalizedMessage());
            String errMsg = e.getMessage();
            return errMsg != null && (errMsg.contains("must not contain multiple segments") || errMsg.startsWith("Invalid thing UID")) ? JSONResponse.createErrorResponse((Response.StatusType)Response.Status.BAD_REQUEST, (String)"Invalid new thing ID.") : JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Thing unable to be approved.");
        }
        if (thing == null) {
            return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.CONFLICT, (String)"No binding found that can create the thing");
        }
        return Response.ok(null, (String)"text/plain").build();
    }

    @DELETE
    @Path(value="/{thingUID}")
    @Operation(operationId="removeItemFromInbox", summary="Removes the discovery result from the inbox.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Discovery result not found in the inbox.")})
    public Response delete(@PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID) {
        if (this.inbox.remove(new ThingUID(thingUID))) {
            return Response.ok(null, (String)"text/plain").build();
        }
        return JSONResponse.createErrorResponse((Response.StatusType)Response.Status.NOT_FOUND, (String)"Thing not found in inbox");
    }

    @GET
    @Produces(value={"application/json"})
    @Operation(operationId="getDiscoveredInboxItems", summary="Get all discovered things.", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DiscoveryResultDTO.class)))})})
    public Response getAll(@QueryParam(value="includeIgnored") @DefaultValue(value="true") @Parameter(description="If true, include ignored inbox entries. Defaults to true") boolean includeIgnored) {
        Stream<Object> discoveryStream = this.inbox.getAll().stream();
        if (!includeIgnored) {
            discoveryStream = discoveryStream.filter(discoveryResult -> discoveryResult.getFlag() != DiscoveryResultFlag.IGNORED);
        }
        return Response.ok((Object)new Stream2JSONInputStream(discoveryStream.map(DiscoveryResultDTOMapper::map))).build();
    }

    @POST
    @Path(value="/{thingUID}/ignore")
    @Operation(operationId="flagInboxItemAsIgnored", summary="Flags a discovery result as ignored for further processing.", responses={@ApiResponse(responseCode="200", description="OK")})
    public Response ignore(@PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID) {
        this.inbox.setFlag(new ThingUID(thingUID), DiscoveryResultFlag.IGNORED);
        return Response.ok(null, (String)"text/plain").build();
    }

    @POST
    @Path(value="/{thingUID}/unignore")
    @Operation(operationId="removeIgnoreFlagOnInboxItem", summary="Removes ignore flag from a discovery result.", responses={@ApiResponse(responseCode="200", description="OK")})
    public Response unignore(@PathParam(value="thingUID") @Parameter(description="thingUID") String thingUID) {
        this.inbox.setFlag(new ThingUID(thingUID), DiscoveryResultFlag.NEW);
        return Response.ok(null, (String)"text/plain").build();
    }
}

