/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.addon.upnp;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.jupnp.UpnpService;
import org.jupnp.model.message.header.RootDeviceHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.ManufacturerDetails;
import org.jupnp.model.meta.ModelDetails;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteDeviceIdentity;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.UDN;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryListener;
import org.openhab.core.addon.AddonDiscoveryMethod;
import org.openhab.core.addon.AddonInfo;
import org.openhab.core.addon.AddonMatchProperty;
import org.openhab.core.config.discovery.addon.AddonFinder;
import org.openhab.core.config.discovery.addon.BaseAddonFinder;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AddonFinder.class}, name="upnp-addon-suggestion-finder")
public class UpnpAddonFinder
extends BaseAddonFinder
implements RegistryListener {
    public static final String SERVICE_TYPE = "upnp";
    public static final String SERVICE_NAME = "upnp-addon-suggestion-finder";
    private static final String DEVICE_TYPE = "deviceType";
    private static final String MANUFACTURER = "manufacturer";
    private static final String MANUFACTURER_URI = "manufacturerURI";
    private static final String MODEL_NAME = "modelName";
    private static final String MODEL_NUMBER = "modelNumber";
    private static final String MODEL_DESCRIPTION = "modelDescription";
    private static final String MODEL_URI = "modelURI";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String FRIENDLY_NAME = "friendlyName";
    private static final Set<String> SUPPORTED_PROPERTIES = Set.of("deviceType", "manufacturer", "manufacturerURI", "modelName", "modelNumber", "modelDescription", "modelURI", "serialNumber", "friendlyName");
    private final Logger logger = LoggerFactory.getLogger(UpnpAddonFinder.class);
    private final Map<String, RemoteDevice> devices = new ConcurrentHashMap<String, RemoteDevice>();
    private final UpnpService upnpService;

    @Activate
    public UpnpAddonFinder(@Reference UpnpService upnpService) {
        this.upnpService = upnpService;
        Registry registry = upnpService.getRegistry();
        for (RemoteDevice device : registry.getRemoteDevices()) {
            this.remoteDeviceAdded(registry, device);
        }
        registry.addListener((RegistryListener)this);
        upnpService.getControlPoint().search();
        upnpService.getControlPoint().search((UpnpHeader)new RootDeviceHeader());
    }

    @Deactivate
    public void deactivate() {
        this.unsetAddonCandidates();
        UpnpService upnpService = this.upnpService;
        upnpService.getRegistry().removeListener((RegistryListener)this);
        this.devices.clear();
    }

    private void addDevice(RemoteDevice device) {
        String udnString;
        UDN udn;
        RemoteDeviceIdentity identity = (RemoteDeviceIdentity)device.getIdentity();
        if (identity != null && (udn = identity.getUdn()) != null && this.devices.put(udnString = udn.getIdentifierString(), device) == null) {
            this.logger.trace("Added device: {}", (Object)device.getDisplayString());
        }
    }

    public Set<AddonInfo> getSuggestedAddons() {
        HashSet<AddonInfo> result = new HashSet<AddonInfo>();
        block0: for (AddonInfo candidate : this.addonCandidates) {
            block1: for (AddonDiscoveryMethod method2 : candidate.getDiscoveryMethods().stream().filter(method -> SERVICE_TYPE.equals(method.getServiceType())).toList()) {
                Map<String, Pattern> matchProperties = method2.getMatchProperties().stream().collect(Collectors.toMap(AddonMatchProperty::getName, AddonMatchProperty::getPattern));
                HashSet<String> propertyNames = new HashSet<String>(matchProperties.keySet());
                propertyNames.removeAll(SUPPORTED_PROPERTIES);
                if (!propertyNames.isEmpty()) {
                    this.logger.warn("Add-on '{}' addon.xml file contains unsupported 'match-property' [{}]", (Object)candidate.getUID(), (Object)String.join((CharSequence)",", propertyNames));
                    continue block0;
                }
                this.logger.trace("Checking candidate: {}", (Object)candidate.getUID());
                for (RemoteDevice device : this.devices.values()) {
                    DeviceDetails devDetails;
                    String deviceType = null;
                    String serialNumber = null;
                    String friendlyName = null;
                    String manufacturer = null;
                    String manufacturerURI = null;
                    String modelName = null;
                    String modelNumber = null;
                    String modelDescription = null;
                    String modelURI = null;
                    DeviceType devType = device.getType();
                    if (devType != null) {
                        deviceType = devType.getType();
                    }
                    if ((devDetails = device.getDetails()) != null) {
                        ModelDetails modDetails;
                        friendlyName = devDetails.getFriendlyName();
                        serialNumber = devDetails.getSerialNumber();
                        ManufacturerDetails mfrDetails = devDetails.getManufacturerDetails();
                        if (mfrDetails != null) {
                            URI mfrUri = mfrDetails.getManufacturerURI();
                            manufacturer = mfrDetails.getManufacturer();
                            String string = manufacturerURI = mfrUri != null ? mfrUri.toString() : null;
                        }
                        if ((modDetails = devDetails.getModelDetails()) != null) {
                            URI modUri = modDetails.getModelURI();
                            modelName = modDetails.getModelName();
                            modelDescription = modDetails.getModelDescription();
                            modelNumber = modDetails.getModelNumber();
                            modelURI = modUri != null ? modUri.toString() : null;
                        }
                    }
                    this.logger.trace("Checking device: {}", (Object)device.getDisplayString());
                    if (!UpnpAddonFinder.propertyMatches(matchProperties, (String)DEVICE_TYPE, (String)deviceType) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)MANUFACTURER, manufacturer) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)MANUFACTURER_URI, manufacturerURI) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)MODEL_NAME, (String)modelName) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)MODEL_NUMBER, (String)modelNumber) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)MODEL_DESCRIPTION, (String)modelDescription) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)MODEL_URI, (String)modelURI) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)SERIAL_NUMBER, (String)serialNumber) || !UpnpAddonFinder.propertyMatches(matchProperties, (String)FRIENDLY_NAME, (String)friendlyName)) continue;
                    result.add(candidate);
                    this.logger.debug("Suggested add-on found: {}", (Object)candidate.getUID());
                    continue block1;
                }
            }
        }
        return result;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void afterShutdown() {
    }

    public void beforeShutdown(@Nullable Registry registry) {
    }

    public void localDeviceAdded(@Nullable Registry registry, @Nullable LocalDevice localDevice) {
    }

    public void localDeviceRemoved(@Nullable Registry registry, @Nullable LocalDevice localDevice) {
    }

    public void remoteDeviceAdded(@Nullable Registry registry, @Nullable RemoteDevice remoteDevice) {
        if (remoteDevice != null) {
            this.addDevice(remoteDevice);
        }
    }

    public void remoteDeviceDiscoveryFailed(@Nullable Registry registry, @Nullable RemoteDevice remoteDevice, @Nullable Exception exception) {
    }

    public void remoteDeviceDiscoveryStarted(@Nullable Registry registry, @Nullable RemoteDevice remoteDevice) {
    }

    public void remoteDeviceRemoved(@Nullable Registry registry, @Nullable RemoteDevice remoteDevice) {
    }

    public void remoteDeviceUpdated(@Nullable Registry registry, @Nullable RemoteDevice remoteDevice) {
        if (remoteDevice != null) {
            this.addDevice(remoteDevice);
        }
    }
}

