/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.GrammarToDot;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.formatting.IElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.ElementMatcherProvider;
import org.eclipse.xtext.formatting.impl.MatcherState;
import org.eclipse.xtext.formatting.impl.MatcherTransition;
import org.eclipse.xtext.grammaranalysis.IGrammarNFAProvider;
import org.eclipse.xtext.util.GraphvizDotBuilder;

public class ElementMatcherToDot
extends GrammarToDot {
    protected IGrammarNFAProvider<MatcherState, MatcherTransition> nfaProvider;

    @Override
    protected GraphvizDotBuilder.Node drawAbstractElementTree(AbstractElement grammarElement, GraphvizDotBuilder.Digraph digraph) {
        GraphvizDotBuilder.Node node = super.drawAbstractElementTree(grammarElement, digraph);
        MatcherState nfas = this.nfaProvider.getNFA(grammarElement);
        for (MatcherTransition outgoing : nfas.getOutgoing()) {
            digraph.add((GraphvizDotBuilder.Props)this.drawFollowerEdge(grammarElement, outgoing, false));
        }
        for (MatcherTransition outgoingAfterReturn : nfas.getOutgoingAfterReturn()) {
            digraph.add((GraphvizDotBuilder.Props)this.drawFollowerEdge(grammarElement, outgoingAfterReturn, true));
        }
        if (nfas.isEndState()) {
            node.put((Object)"peripheries", (Object)"2");
        }
        if (!nfas.hasTransitions()) {
            node.setStyle("dotted");
        }
        return node;
    }

    protected String toStr(Iterable<IElementMatcherProvider.IElementPattern> list) {
        String s1 = Joiner.on((String)", ").join(list);
        String s2 = s1.replaceAll("\\\\n|\\n", "\\\\\\\\n");
        return s2;
    }

    protected GraphvizDotBuilder.Edge drawFollowerEdge(AbstractElement grammarElement, MatcherTransition transition, boolean isParent) {
        GraphvizDotBuilder.Edge edge = new GraphvizDotBuilder.Edge((GraphvizDotBuilder)this, (Object)grammarElement, (Object)((MatcherState)transition.getTarget()).getGrammarElement());
        ArrayList label = Lists.newArrayList();
        if (!transition.getCommonPatterns().isEmpty()) {
            label.add("{" + this.toStr(transition.getCommonPatterns()) + "}");
        }
        for (Map.Entry<MatcherState, Set<IElementMatcherProvider.IElementPattern>> e : transition.getGuardPatterns().entrySet()) {
            label.add(GrammarUtil.containingRule(e.getKey().getGrammarElement()).getName() + "-" + String.valueOf(e.getKey()) + ":{" + this.toStr((Iterable<IElementMatcherProvider.IElementPattern>)e.getValue()) + "}");
        }
        if (label.size() > 0) {
            edge.setLabel(Joiner.on((String)"\\n").join((Iterable)label));
        }
        if (isParent) {
            edge.put((Object)"arrowtail", (Object)"odot");
        }
        if (transition.isRuleCall()) {
            edge.put((Object)"arrowhead", (Object)"onormalonormal");
        } else {
            edge.put((Object)"arrowhead", (Object)"onormal");
        }
        return edge;
    }

    @Override
    protected GraphvizDotBuilder.Props drawGrammarContainementEdge(AbstractElement container, AbstractElement child) {
        GraphvizDotBuilder.Edge edge = new GraphvizDotBuilder.Edge((GraphvizDotBuilder)this, (Object)container, (Object)child);
        edge.setStyle("dotted");
        return edge;
    }

    @Override
    protected GraphvizDotBuilder.Props drawObject(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Obj null");
        }
        if (obj instanceof ElementMatcherProvider.TransitionMatcher) {
            ElementMatcherProvider.TransitionMatcher m = (ElementMatcherProvider.TransitionMatcher)obj;
            this.nfaProvider = m.nfaProvider;
            return super.drawObject(m.getGrammar().getGrammar());
        }
        return super.drawObject(obj);
    }

    @Override
    protected GraphvizDotBuilder.Node newNode(EObject semanticObject, String label) {
        if (semanticObject.eContainer() instanceof AbstractRule) {
            AbstractRule rule = (AbstractRule)semanticObject.eContainer();
            return new GraphvizDotBuilder.Node((GraphvizDotBuilder)this, (Object)semanticObject, rule.getName() + ":\\n" + label, "record");
        }
        return new GraphvizDotBuilder.Node((GraphvizDotBuilder)this, (Object)semanticObject, label);
    }
}

