/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.DatagramIOConfigurationImpl;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.DatagramProcessor;
import org.jupnp.transport.spi.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramIOImpl
implements DatagramIO<DatagramIOConfigurationImpl> {
    private final Logger logger = LoggerFactory.getLogger(DatagramIOImpl.class);
    protected final DatagramIOConfigurationImpl configuration;
    protected Router router;
    protected DatagramProcessor datagramProcessor;
    protected InetSocketAddress localAddress;
    protected MulticastSocket socket;

    public DatagramIOImpl(DatagramIOConfigurationImpl configuration) {
        this.configuration = configuration;
    }

    @Override
    public DatagramIOConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    public synchronized void init(InetAddress bindAddress, int bindPort, Router router, DatagramProcessor datagramProcessor) throws InitializationException {
        this.router = router;
        this.datagramProcessor = datagramProcessor;
        try {
            this.logger.debug("Creating bound socket (for datagram input/output) on: {}:{}", (Object)bindAddress, (Object)bindPort);
            this.localAddress = new InetSocketAddress(bindAddress, bindPort);
            this.socket = new MulticastSocket(this.localAddress);
            this.socket.setTimeToLive(this.configuration.getTimeToLive());
            this.socket.setReceiveBufferSize(262144);
        }
        catch (Exception e) {
            throw new InitializationException("Could not initialize " + this.getClass().getSimpleName(), e);
        }
    }

    @Override
    public synchronized void stop() {
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public void run() {
        this.logger.debug("Entering blocking receiving loop, listening for UDP datagrams on: {}:{}", (Object)this.socket.getLocalAddress(), (Object)this.socket.getPort());
        while (true) {
            try {
                while (true) {
                    byte[] buf = new byte[this.getConfiguration().getMaxDatagramBytes()];
                    DatagramPacket datagram = new DatagramPacket(buf, buf.length);
                    this.socket.receive(datagram);
                    this.logger.debug("UDP datagram received from: {}:{} on: {}", new Object[]{datagram.getAddress().getHostAddress(), datagram.getPort(), this.localAddress});
                    this.router.received(this.datagramProcessor.read(this.localAddress.getAddress(), datagram));
                }
            }
            catch (SocketException e) {
                this.logger.debug("Socket closed");
            }
            catch (UnsupportedDataException e) {
                this.logger.info("Could not read datagram: {}", (Object)e.getMessage());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            break;
        }
        try {
            if (!this.socket.isClosed()) {
                this.logger.debug("Closing unicast socket");
                this.socket.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void send(OutgoingDatagramMessage message) {
        this.logger.debug("Sending message from address: {}", (Object)this.localAddress);
        DatagramPacket packet = this.datagramProcessor.write(message);
        this.logger.debug("Sending UDP datagram packet to: {}:{}", (Object)message.getDestinationAddress(), (Object)message.getDestinationPort());
        this.send(packet);
    }

    @Override
    public synchronized void send(DatagramPacket datagram) {
        this.logger.debug("Sending message from address: {}", (Object)this.localAddress);
        try {
            this.socket.send(datagram);
        }
        catch (SocketException e) {
            this.logger.debug("Socket closed, aborting datagram send to: {}", (Object)datagram.getAddress());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.error("Exception sending datagram to: {}", (Object)datagram.getAddress(), (Object)e);
            this.logger.error("  Details: datagram.socketAddress={}, length={}, offset={}, data.bytes={}", new Object[]{datagram.getSocketAddress(), datagram.getLength(), datagram.getOffset(), datagram.getData().length});
            try {
                this.logger.error("  Details: socket={}, closed={}, bound={}, inetAddress={}, remoteSocketAddress={}, networkInterface={}", new Object[]{this.socket.toString(), this.socket.isClosed(), this.socket.isBound(), this.socket.getInetAddress(), this.socket.getRemoteSocketAddress(), this.socket.getNetworkInterface()});
            }
            catch (SocketException ex2) {
                this.logger.error("  Details: could not get network interface", (Throwable)ex2);
            }
        }
    }
}

