/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.region.StandardRegionDigraph;
import org.eclipse.equinox.internal.region.StandardRegionFilter;
import org.eclipse.equinox.internal.region.StandardRegionFilterBuilder;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.RegionDigraphPersistence;
import org.eclipse.equinox.region.RegionFilter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public final class StandardRegionDigraphPersistence
implements RegionDigraphPersistence {
    private static final String PERSISTENT_NAME = "equinox region digraph";
    private static final int PERSISTENT_VERSION = 1;

    static void writeRegionDigraph(DataOutputStream out, RegionDigraph digraph) throws IOException {
        if (!(digraph instanceof StandardRegionDigraph)) {
            throw new IllegalArgumentException("Only digraphs of type '" + StandardRegionDigraph.class.getName() + "' are allowed: " + digraph.getClass().getName());
        }
        Map<Region, Set<RegionDigraph.FilteredRegion>> filteredRegions = ((StandardRegionDigraph)digraph).getFilteredRegions();
        try {
            out.writeUTF(PERSISTENT_NAME);
            out.writeInt(1);
            out.writeInt(filteredRegions.size());
            for (Region region : filteredRegions.keySet()) {
                StandardRegionDigraphPersistence.writeRegion(out, region);
            }
            out.writeInt(filteredRegions.size());
            for (Map.Entry entry : filteredRegions.entrySet()) {
                out.writeInt(((Set)entry.getValue()).size());
                for (RegionDigraph.FilteredRegion edge : (Set)entry.getValue()) {
                    StandardRegionDigraphPersistence.writeEdge(out, (Region)entry.getKey(), edge.getFilter(), edge.getRegion());
                }
            }
        }
        finally {
            out.flush();
        }
    }

    private static void writeRegion(DataOutputStream out, Region region) throws IOException {
        out.writeUTF(region.getName());
        Set<Long> ids = region.getBundleIds();
        out.writeInt(ids.size());
        for (Long id : ids) {
            out.writeLong(id);
        }
    }

    private static void writeEdge(DataOutputStream out, Region tail, RegionFilter filter, Region head) throws IOException {
        out.writeUTF(tail.getName());
        out.writeUTF(head.getName());
        Map<String, Collection<String>> policy = filter.getSharingPolicy();
        out.writeInt(policy.size());
        for (Map.Entry<String, Collection<String>> namespace : policy.entrySet()) {
            out.writeUTF(namespace.getKey());
            Collection<String> filters = namespace.getValue();
            out.writeInt(filters.size());
            for (String filterSpec : filters) {
                out.writeUTF(filterSpec);
            }
        }
    }

    static StandardRegionDigraph readRegionDigraph(DataInputStream in, BundleContext bundleContext, ThreadLocal<Region> threadLocal) throws IOException, InvalidSyntaxException, BundleException {
        StandardRegionDigraph digraph = new StandardRegionDigraph(bundleContext, threadLocal);
        String persistentName = in.readUTF();
        if (!PERSISTENT_NAME.equals(persistentName)) {
            throw new IllegalArgumentException("Input stream does not represent a digraph");
        }
        int persistentVersion = in.readInt();
        if (1 != persistentVersion) {
            throw new IllegalArgumentException("Input stream contains a digraph with an incompatible version '" + persistentVersion + "'");
        }
        int numRegions = in.readInt();
        int i = 0;
        while (i < numRegions) {
            StandardRegionDigraphPersistence.readRegion(in, digraph, bundleContext);
            ++i;
        }
        int numTails = in.readInt();
        int i2 = 0;
        while (i2 < numTails) {
            int numEdges = in.readInt();
            int j = 0;
            while (j < numEdges) {
                StandardRegionDigraphPersistence.readEdge(in, digraph);
                ++j;
            }
            ++i2;
        }
        return digraph;
    }

    private static Region readRegion(DataInputStream in, RegionDigraph digraph, BundleContext context) throws IOException, BundleException {
        String name = in.readUTF();
        Region region = digraph.createRegion(name);
        int numIds = in.readInt();
        int i = 0;
        while (i < numIds) {
            long id = in.readLong();
            if (context == null || context.getBundle(id) != null) {
                region.addBundle(id);
            }
            ++i;
        }
        return region;
    }

    private static void readEdge(DataInputStream in, RegionDigraph digraph) throws IOException, InvalidSyntaxException, BundleException {
        String tailName = in.readUTF();
        Region tail = digraph.getRegion(tailName);
        if (tail == null) {
            throw new IOException("Could not find tail region: " + tailName);
        }
        String headName = in.readUTF();
        Region head = digraph.getRegion(headName);
        if (head == null) {
            throw new IOException("Could not find head region: " + headName);
        }
        HashMap<String, Collection<Filter>> filters = new HashMap<String, Collection<Filter>>();
        int numSpaces = in.readInt();
        int i = 0;
        while (i < numSpaces) {
            String namespace = in.readUTF();
            int numFilters = in.readInt();
            int j = 0;
            while (j < numFilters) {
                String filter = in.readUTF();
                ArrayList<Filter> namespaceFilters = (ArrayList<Filter>)filters.get(namespace);
                if (namespaceFilters == null) {
                    namespaceFilters = new ArrayList<Filter>(numFilters);
                    filters.put(namespace, namespaceFilters);
                }
                namespaceFilters.add(StandardRegionFilterBuilder.createFilter(filter));
                ++j;
            }
            ++i;
        }
        digraph.connect(tail, new StandardRegionFilter(filters), head);
    }

    @Override
    public RegionDigraph load(InputStream input) throws IOException {
        try {
            return StandardRegionDigraphPersistence.readRegionDigraph(new DataInputStream(input), null, null);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException("Internal error reading a filter", e);
        }
        catch (BundleException e) {
            throw new IllegalStateException("Internal error creating the digraph", e);
        }
    }

    @Override
    public void save(RegionDigraph digraph, OutputStream output) throws IOException {
        StandardRegionDigraphPersistence.writeRegionDigraph(new DataOutputStream(output), digraph);
    }
}

