/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.io;

import net.wimpi.modbus.ModbusException;
import net.wimpi.modbus.ModbusIOException;
import net.wimpi.modbus.ModbusSlaveException;
import net.wimpi.modbus.io.ModbusTransaction;
import net.wimpi.modbus.io.ModbusTransport;
import net.wimpi.modbus.msg.ExceptionResponse;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.net.SerialConnection;
import net.wimpi.modbus.util.AtomicCounter;
import net.wimpi.modbus.util.Mutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSerialTransaction
implements ModbusTransaction {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSerialTransaction.class);
    private static AtomicCounter c_TransactionID = new AtomicCounter(0);
    private ModbusTransport m_IO;
    private ModbusRequest m_Request;
    private ModbusResponse m_Response;
    private boolean m_ValidityCheck = true;
    private int m_Retries = 3;
    private long m_RetryDelayMillis;
    private int m_TransDelayMS = 0;
    private SerialConnection m_SerialCon;
    private Mutex m_TransactionLock = new Mutex();

    public ModbusSerialTransaction() {
    }

    public ModbusSerialTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusSerialTransaction(SerialConnection con) {
        this.setSerialConnection(con);
    }

    public void setSerialConnection(SerialConnection con) {
        this.m_SerialCon = con;
        this.m_IO = con.getModbusTransport();
    }

    @Override
    public int getTransactionID() {
        return c_TransactionID.get();
    }

    @Override
    public void setRequest(ModbusRequest req) {
        this.m_Request = req;
    }

    @Override
    public ModbusRequest getRequest() {
        return this.m_Request;
    }

    @Override
    public ModbusResponse getResponse() {
        return this.m_Response;
    }

    @Override
    public void setCheckingValidity(boolean b) {
        this.m_ValidityCheck = b;
    }

    @Override
    public boolean isCheckingValidity() {
        return this.m_ValidityCheck;
    }

    @Override
    public int getRetries() {
        return this.m_Retries;
    }

    @Override
    public void setRetries(int num) {
        this.m_Retries = num;
    }

    public int getTransDelayMS() {
        return this.m_TransDelayMS;
    }

    public void setTransDelayMS(int newTransDelayMS) {
        this.m_TransDelayMS = newTransDelayMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ModbusIOException, ModbusSlaveException, ModbusException {
        this.assertExecutable();
        try {
            this.m_TransactionLock.acquire();
            ModbusTransport modbusTransport = this.m_IO;
            synchronized (modbusTransport) {
                int tries = 0;
                while (true) {
                    this.m_Request.setTransactionID(c_TransactionID.increment());
                    try {
                        if (this.m_TransDelayMS > 0) {
                            try {
                                Thread.sleep(this.m_TransDelayMS);
                            }
                            catch (InterruptedException ex) {
                                logger.debug("InterruptedException: {}", (Object)ex.getMessage());
                                throw ex;
                            }
                        }
                        this.m_IO.writeMessage(this.m_Request);
                        this.m_Response = this.m_IO.readResponse();
                    }
                    catch (ModbusIOException e) {
                        logger.debug("execute try {}/{} error: {}. Request: {} (unit id {} & transaction {}). Serial parameters: {}", new Object[]{++tries, this.m_Retries + 1, e.getMessage(), this.m_Request, this.m_Request.getUnitID(), this.m_Request.getTransactionID(), this.m_SerialCon.getParameters()});
                        if (tries >= this.m_Retries) {
                            logger.debug("execute reached max tries {}, throwing last error: {}. Request: {} (unit id {} & transaction {}). Serial parameters: {}", new Object[]{this.m_Retries + 1, e.getMessage(), this.m_Request, this.m_Request.getUnitID(), this.m_Request.getTransactionID(), this.m_SerialCon.getParameters()});
                            throw e;
                        }
                        Thread.sleep(this.m_RetryDelayMillis);
                        continue;
                    }
                    break;
                }
                if (tries > 0) {
                    logger.debug("execute eventually succeeded with {} re-tries. Request: {} (unit id {} & transaction id {}). Serial parameters: {}", new Object[]{tries, this.m_Request, this.m_Request.getUnitID(), this.m_Request.getTransactionID(), this.m_SerialCon.getParameters()});
                }
            }
            if (this.m_Response instanceof ExceptionResponse) {
                throw new ModbusSlaveException(((ExceptionResponse)this.m_Response).getExceptionCode());
            }
            if (this.isCheckingValidity()) {
                this.checkValidity();
            }
        }
        catch (InterruptedException ex) {
            throw new ModbusIOException("Thread acquiring lock was interrupted.");
        }
        finally {
            this.m_TransactionLock.release();
        }
    }

    private void assertExecutable() throws ModbusException {
        if (this.m_Request == null || this.m_SerialCon == null) {
            throw new ModbusException("Assertion failed, transaction not executable");
        }
    }

    protected void checkValidity() throws ModbusException {
    }

    @Override
    public long getRetryDelayMillis() {
        return this.m_RetryDelayMillis;
    }

    @Override
    public void setRetryDelayMillis(long retryDelayMillis) {
        this.m_RetryDelayMillis = retryDelayMillis;
    }
}

