/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model;

import org.opensearch.searchrelevance.utils.MathUtils;

public class ClickthroughRate {
    private final String objectId;
    private int clicks;
    private int impressions;
    private int rank;

    public ClickthroughRate(String objectId) {
        this.objectId = objectId;
        this.clicks = 0;
        this.impressions = 0;
        this.rank = Integer.MAX_VALUE;
    }

    public ClickthroughRate(String objectId, int clicks, int impressions, int rank) {
        this.objectId = objectId;
        this.clicks = clicks;
        this.impressions = impressions;
        this.rank = rank;
    }

    public String toString() {
        return "object_id: " + this.objectId + ", clicks: " + this.clicks + ", events: " + this.impressions + ", rank: " + this.rank + ", ctr: " + MathUtils.round(this.getClickthroughRate());
    }

    public void logClick() {
        ++this.clicks;
    }

    public void logImpression() {
        ++this.impressions;
    }

    public void logRank(int rank) {
        if (rank < this.rank) {
            this.rank = rank;
        }
    }

    public double getClickthroughRate() {
        return (double)this.clicks / (double)this.impressions;
    }

    public int getClicks() {
        return this.clicks;
    }

    public int getRank() {
        return this.rank;
    }

    public int getImpressions() {
        return this.impressions;
    }

    public String getObjectId() {
        return this.objectId;
    }
}

