/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.system.applicationtemplates;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opensearch.cluster.applicationtemplates.ClusterStateSystemTemplateLoader;
import org.opensearch.cluster.applicationtemplates.SystemTemplateLoader;
import org.opensearch.cluster.applicationtemplates.SystemTemplateMetadata;
import org.opensearch.cluster.applicationtemplates.SystemTemplateRepository;
import org.opensearch.cluster.applicationtemplates.SystemTemplatesPlugin;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.plugins.Plugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.script.ScriptService;
import org.opensearch.system.applicationtemplates.LocalSystemTemplateRepository;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class ApplicationBasedConfigurationSystemTemplatesPlugin
extends Plugin
implements SystemTemplatesPlugin {
    private ClusterService clusterService;
    private Client client;
    private final Map<String, SystemTemplateLoader> loaders = new HashMap<String, SystemTemplateLoader>();

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService = clusterService;
        this.client = client;
        return super.createComponents(client, clusterService, threadPool, resourceWatcherService, scriptService, xContentRegistry, environment, nodeEnvironment, namedWriteableRegistry, indexNameExpressionResolver, repositoriesServiceSupplier);
    }

    public SystemTemplateRepository loadRepository() throws IOException {
        return new LocalSystemTemplateRepository();
    }

    public SystemTemplateLoader loaderFor(SystemTemplateMetadata templateMetadata) {
        return this.loaders.computeIfAbsent(templateMetadata.type(), k -> {
            if ("@abc_template".equals(templateMetadata.type())) {
                return new ClusterStateSystemTemplateLoader(this.client, () -> this.clusterService.state());
            }
            return null;
        });
    }
}

