/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script.expression;

import java.io.IOException;
import java.util.Objects;
import java.util.function.ToIntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DoubleValues;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableDateTime;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.LeafNumericFieldData;
import org.opensearch.index.fielddata.NumericDoubleValues;
import org.opensearch.script.expression.FieldDataValueSource;
import org.opensearch.search.MultiValueMode;

class DateObjectValueSource
extends FieldDataValueSource {
    final String methodName;
    final ToIntFunction<ReadableDateTime> function;

    DateObjectValueSource(IndexFieldData<?> indexFieldData, MultiValueMode multiValueMode, String methodName, ToIntFunction<ReadableDateTime> function) {
        super(indexFieldData, multiValueMode);
        Objects.requireNonNull(methodName);
        this.methodName = methodName;
        this.function = function;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext leaf, DoubleValues scores) {
        LeafNumericFieldData leafData = (LeafNumericFieldData)this.fieldData.load(leaf);
        final MutableDateTime joda = new MutableDateTime(0L, DateTimeZone.UTC);
        final NumericDoubleValues docValues = this.multiValueMode.select(leafData.getDoubleValues());
        return new DoubleValues(this){
            final /* synthetic */ DateObjectValueSource this$0;
            {
                this.this$0 = this$0;
            }

            public double doubleValue() throws IOException {
                joda.setMillis((long)docValues.doubleValue());
                return this.this$0.function.applyAsInt((ReadableDateTime)joda);
            }

            public boolean advanceExact(int doc) throws IOException {
                return docValues.advanceExact(doc);
            }
        };
    }

    @Override
    public String toString() {
        return this.methodName + ": field(" + this.fieldData.getFieldName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DateObjectValueSource that = (DateObjectValueSource)((Object)o);
        return this.methodName.equals(that.methodName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.methodName.hashCode();
        return result;
    }
}

