/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.explore;

import java.util.ArrayList;

public class StatisticsHelper {
    private final ArrayList<Float> data = new ArrayList(10);
    private float min = Float.MAX_VALUE;
    private float max = 0.0f;

    public void add(float val) {
        this.data.add(Float.valueOf(val));
        if (val < this.min) {
            this.min = val;
        }
        if (val > this.max) {
            this.max = val;
        }
    }

    public ArrayList<Float> getData() {
        return this.data;
    }

    public int getSize() {
        return this.data.size();
    }

    public float getMax() {
        assert (!this.data.isEmpty());
        return this.max;
    }

    public float getMin() {
        assert (!this.data.isEmpty());
        return this.min;
    }

    public float getMean() {
        assert (!this.data.isEmpty());
        return this.getSum() / (float)this.data.size();
    }

    public float getSum() {
        assert (!this.data.isEmpty());
        float sum = 0.0f;
        for (float a : this.data) {
            sum += a;
        }
        return sum;
    }

    public float getVariance() {
        assert (!this.data.isEmpty());
        float mean = this.getMean();
        float temp = 0.0f;
        for (float a : this.data) {
            temp += (a - mean) * (a - mean);
        }
        return temp / (float)this.data.size();
    }

    public float getStdDev() {
        assert (!this.data.isEmpty());
        return (float)Math.sqrt(this.getVariance());
    }

    public float getAggr(AggrType type) {
        switch (type.ordinal()) {
            case 0: {
                return this.getMean();
            }
            case 1: {
                return this.getMax();
            }
            case 2: {
                return this.getMin();
            }
            case 3: {
                return this.getSum();
            }
            case 4: {
                return this.getStdDev();
            }
        }
        return 0.0f;
    }

    public static enum AggrType {
        AVG("avg"),
        MAX("max"),
        MIN("min"),
        SUM("sum"),
        STDDEV("stddev"),
        MATCHES("matches");

        private String type;

        private AggrType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

