/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.utils;

import java.util.Objects;
import java.util.function.Supplier;

public final class Suppliers {
    private Suppliers() {
    }

    public static <E> Supplier<E> memoize(Supplier<E> supplier) {
        return new MemoizeSupplier<E>(supplier);
    }

    private static class MemoizeSupplier<E>
    implements Supplier<E> {
        private volatile boolean initialized = false;
        private final Supplier<E> supplier;
        private E value;

        MemoizeSupplier(Supplier<E> supplier) {
            this.supplier = Objects.requireNonNull(supplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get() {
            if (!this.initialized) {
                MemoizeSupplier memoizeSupplier = this;
                synchronized (memoizeSupplier) {
                    if (!this.initialized) {
                        E t = this.supplier.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }
    }
}

