/*
 * Decompiled with CFR 0.152.
 */
package DafnyLibraries;

import dafny.DafnySequence;
import dafny.Tuple2;
import dafny.Tuple3;
import dafny.TypeDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class FileIO {
    public static Tuple3<Boolean, DafnySequence<? extends Byte>, DafnySequence<? extends Character>> INTERNAL_ReadBytesFromFile(DafnySequence<? extends Character> path) {
        try {
            Path pathObj = FileIO.dafnyStringToPath(path);
            DafnySequence readBytes = DafnySequence.fromBytes((byte[])Files.readAllBytes(pathObj));
            return Tuple3.create((Object)false, (Object)readBytes, (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        }
        catch (Exception ex) {
            return Tuple3.create((Object)true, (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.BYTE), FileIO.stackTraceToDafnyString(ex));
        }
    }

    public static Tuple2<Boolean, DafnySequence<? extends Character>> INTERNAL_WriteBytesToFile(DafnySequence<? extends Character> path, DafnySequence<? extends Byte> bytes) {
        try {
            Path pathObj = FileIO.dafnyStringToPath(path);
            FileIO.createParentDirs(pathObj);
            byte[] byteArr = DafnySequence.toByteArray(bytes);
            Files.write(pathObj, byteArr, new OpenOption[0]);
            return Tuple2.create((Object)false, (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        }
        catch (Exception ex) {
            return Tuple2.create((Object)true, FileIO.stackTraceToDafnyString(ex));
        }
    }

    public static Tuple2<Boolean, DafnySequence<? extends Character>> INTERNAL_AppendBytesToFile(DafnySequence<? extends Character> path, DafnySequence<? extends Byte> bytes) {
        try {
            Path pathObj = FileIO.dafnyStringToPath(path);
            FileIO.createParentDirs(pathObj);
            byte[] byteArr = DafnySequence.toByteArray(bytes);
            OutputStream out = Files.newOutputStream(pathObj, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            out.write(byteArr);
            out.close();
            return Tuple2.create((Object)false, (Object)DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        }
        catch (Exception ex) {
            return Tuple2.create((Object)true, FileIO.stackTraceToDafnyString(ex));
        }
    }

    private static final Path dafnyStringToPath(DafnySequence<? extends Character> path) {
        return Paths.get(new String((char[])path.toArray().unwrap()), new String[0]);
    }

    private static final void createParentDirs(Path path) throws IOException {
        Path parentDir = path.toAbsolutePath().getParent();
        if (parentDir == null) {
            return;
        }
        Files.createDirectories(parentDir, new FileAttribute[0]);
    }

    private static final DafnySequence<Character> stackTraceToDafnyString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        String str = stringWriter.toString();
        return DafnySequence.of((char[])str.toCharArray());
    }
}

