/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.action.monitor.request;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.commons.alerting.model.Alert;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class UpdateThreatIntelAlertStatusRequest
extends ActionRequest {
    public static final String ALERT_IDS_FIELD = "alert_ids";
    public static final String STATE_FIELD = "state";
    private final List<String> alertIds;
    private final Alert.State state;
    private final String monitorId;

    public UpdateThreatIntelAlertStatusRequest(StreamInput sin) throws IOException {
        this.alertIds = sin.readStringList();
        this.state = (Alert.State)sin.readEnum(Alert.State.class);
        this.monitorId = sin.readOptionalString();
    }

    public UpdateThreatIntelAlertStatusRequest(List<String> alertIds, Alert.State state) {
        this.alertIds = alertIds;
        this.state = state;
        this.monitorId = null;
    }

    public UpdateThreatIntelAlertStatusRequest(List<String> alertIds, String monitorId, Alert.State state) {
        this.alertIds = alertIds;
        this.state = state;
        this.monitorId = monitorId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringCollection(this.alertIds);
        out.writeEnum((Enum)this.state);
        out.writeOptionalString(this.monitorId);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException actionRequestValidationException = null;
        if (this.state == null) {
            actionRequestValidationException = new ActionRequestValidationException();
            actionRequestValidationException.addValidationError("State cannot be null");
        }
        if (this.alertIds == null || this.alertIds.isEmpty()) {
            actionRequestValidationException = new ActionRequestValidationException();
            actionRequestValidationException.addValidationError("At least one alert id is required");
        }
        if (!(this.state.equals((Object)Alert.State.ACKNOWLEDGED) || this.state.equals((Object)Alert.State.COMPLETED))) {
            actionRequestValidationException = new ActionRequestValidationException();
            actionRequestValidationException.addValidationError(String.format("%s is not a supported state for alert status update. Only COMPLETED and ACKNOWLEDGED states allowed", this.state.toString()));
        }
        return actionRequestValidationException;
    }

    public List<String> getAlertIds() {
        return this.alertIds;
    }

    public Alert.State getState() {
        return this.state;
    }

    public String getMonitorId() {
        return this.monitorId;
    }
}

