/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateVariant;
import org.opensearch.client.opensearch._types.aggregations.DateHistogramBucket;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AutoDateHistogramAggregate
extends MultiBucketAggregateBase<DateHistogramBucket>
implements AggregateVariant,
ToCopyableBuilder<Builder, AutoDateHistogramAggregate> {
    @Nonnull
    private final Time interval;
    public static final JsonpDeserializer<AutoDateHistogramAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AutoDateHistogramAggregate::setupAutoDateHistogramAggregateDeserializer);

    private AutoDateHistogramAggregate(Builder builder) {
        super(builder);
        this.interval = ApiTypeHelper.requireNonNull(builder.interval, this, "interval");
    }

    public static AutoDateHistogramAggregate of(Function<Builder, ObjectBuilder<AutoDateHistogramAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.AutoDateHistogram;
    }

    @Nonnull
    public final Time interval() {
        return this.interval;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("interval");
        this.interval.serialize(generator, mapper);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAutoDateHistogramAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AutoDateHistogramAggregate.setupMultiBucketAggregateBaseDeserializer(op, DateHistogramBucket._DESERIALIZER);
        op.add(Builder::interval, Time._DESERIALIZER, "interval");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.interval.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AutoDateHistogramAggregate other = (AutoDateHistogramAggregate)o;
        return this.interval.equals(other.interval);
    }

    public static class Builder
    extends MultiBucketAggregateBase.AbstractBuilder<DateHistogramBucket, Builder>
    implements CopyableBuilder<Builder, AutoDateHistogramAggregate> {
        private Time interval;

        public Builder() {
        }

        private Builder(AutoDateHistogramAggregate o) {
            super(o);
            this.interval = o.interval;
        }

        private Builder(Builder o) {
            super(o);
            this.interval = o.interval;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder interval(Time value) {
            this.interval = value;
            return this;
        }

        @Nonnull
        public final Builder interval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.interval(fn.apply(new Time.Builder()).build());
        }

        @Override
        @Nonnull
        public AutoDateHistogramAggregate build() {
            this._checkSingleUse();
            return new AutoDateHistogramAggregate(this);
        }
    }
}

