/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.plan;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rex.RexNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LogicalSystemLimit
extends Sort {
    private final SystemLimitType type;

    private LogicalSystemLimit(SystemLimitType type, RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        this(type, cluster, traitSet, Collections.emptyList(), input, collation, offset, fetch);
    }

    private LogicalSystemLimit(SystemLimitType type, RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traitSet, hints, input, collation, offset, fetch);
        assert (traitSet.containsIfApplicable((RelTrait)Convention.NONE));
        this.type = type;
    }

    public static LogicalSystemLimit create(SystemLimitType type, RelNode input, RexNode fetch) {
        return LogicalSystemLimit.create(type, input, null, fetch);
    }

    public static LogicalSystemLimit create(SystemLimitType type, RelNode input, @Nullable RexNode offset, @Nullable RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        List collations = input.getTraitSet().getTraits((RelTraitDef)RelCollationTraitDef.INSTANCE);
        RelCollation collation = collations == null ? null : (RelCollation)collations.get(0);
        collation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)collation);
        RelTraitSet traitSet = input.getTraitSet().replace((RelTrait)Convention.NONE).replace((RelTrait)collation);
        return new LogicalSystemLimit(type, cluster, traitSet, input, collation, offset, fetch);
    }

    public Sort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        return new LogicalSystemLimit(this.type, this.getCluster(), traitSet, (List<RelHint>)this.hints, newInput, newCollation, offset, fetch);
    }

    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        pw.item("type", (Object)this.type);
        return pw;
    }

    @Generated
    public SystemLimitType getType() {
        return this.type;
    }

    public static enum SystemLimitType {
        QUERY_SIZE_LIMIT,
        JOIN_SUBSEARCH_MAXOUT,
        SUBSEARCH_MAXOUT;

    }
}

