/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;
import org.opensearch.threadpool.ThreadPool;

public class ProcessNode {
    private static final Logger logger = LogManager.getLogger(ProcessNode.class);
    private final String id;
    private final WorkflowStep workflowStep;
    private final Map<String, String> previousNodeInputs;
    private final Map<String, String> params;
    private final WorkflowData input;
    private final List<ProcessNode> predecessors;
    private final ThreadPool threadPool;
    private final String threadPoolName;
    private final TimeValue nodeTimeout;
    private final String tenantId;
    private final PlainActionFuture<WorkflowData> future = PlainActionFuture.newFuture();

    public ProcessNode(String id, WorkflowStep workflowStep, Map<String, String> previousNodeInputs, Map<String, String> params, WorkflowData input, List<ProcessNode> predecessors, ThreadPool threadPool, String threadPoolName, TimeValue nodeTimeout, String tenantId) {
        this.id = id;
        this.workflowStep = workflowStep;
        this.previousNodeInputs = previousNodeInputs;
        this.params = params;
        this.input = input;
        this.predecessors = predecessors;
        this.threadPool = threadPool;
        this.threadPoolName = threadPoolName;
        this.nodeTimeout = nodeTimeout;
        this.tenantId = tenantId;
    }

    public String id() {
        return this.id;
    }

    public WorkflowStep workflowStep() {
        return this.workflowStep;
    }

    public Map<String, String> previousNodeInputs() {
        return this.previousNodeInputs;
    }

    public Map<String, String> params() {
        return this.params;
    }

    public WorkflowData input() {
        return this.input;
    }

    public PlainActionFuture<WorkflowData> future() {
        return this.future;
    }

    public List<ProcessNode> predecessors() {
        return this.predecessors;
    }

    public TimeValue nodeTimeout() {
        return this.nodeTimeout;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public PlainActionFuture<WorkflowData> execute() {
        if (this.future.isDone()) {
            throw new IllegalStateException("Process Node [" + this.id + "] already executed.");
        }
        CompletableFuture.runAsync(() -> {
            try {
                HashMap<String, WorkflowData> inputMap = new HashMap<String, WorkflowData>();
                for (ProcessNode node : this.predecessors) {
                    WorkflowData wd = (WorkflowData)node.future().actionGet();
                    inputMap.put(wd.getNodeId(), wd);
                }
                logger.info("Starting {}.", (Object)this.id);
                PlainActionFuture<WorkflowData> stepFuture = this.workflowStep.execute(this.id, this.input, inputMap, this.previousNodeInputs, this.params, this.tenantId);
                this.future.onResponse((Object)((WorkflowData)stepFuture.actionGet(this.nodeTimeout)));
                logger.info("Finished {}.", (Object)this.id);
            }
            catch (Exception e) {
                this.future.onFailure(e);
            }
        }, this.threadPool.executor(this.threadPoolName));
        return this.future;
    }

    public String toString() {
        return this.id;
    }
}

