/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.time;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.sql.calcite.utils.binning.time.TimeUnitConfig;

public class TimeUnitRegistry {
    private static final Map<String, TimeUnitConfig> UNIT_MAPPING = new HashMap<String, TimeUnitConfig>();

    public static TimeUnitConfig getConfig(String unit) {
        if (unit.equals("M")) {
            return UNIT_MAPPING.get(unit);
        }
        return UNIT_MAPPING.get(unit.toLowerCase());
    }

    public static void validateSubSecondSpan(TimeUnitConfig config, int intervalValue) {
        if (!TimeUnitRegistry.isSubSecondUnit(config)) {
            return;
        }
        long intervalMicros = switch (config) {
            case TimeUnitConfig.MICROSECONDS -> intervalValue;
            case TimeUnitConfig.MILLISECONDS -> (long)intervalValue * 1000L;
            case TimeUnitConfig.CENTISECONDS -> (long)intervalValue * 10000L;
            case TimeUnitConfig.DECISECONDS -> (long)intervalValue * 100000L;
            default -> 0L;
        };
        long oneSecondMicros = 1000000L;
        if (intervalMicros >= oneSecondMicros) {
            throw new IllegalArgumentException(String.format("Sub-second span %d%s must be less than 1 second", intervalValue, config.getUnit()));
        }
        if (oneSecondMicros % intervalMicros != 0L) {
            throw new IllegalArgumentException(String.format("1 second must be evenly divisible by span %d%s", intervalValue, config.getUnit()));
        }
    }

    private static boolean isSubSecondUnit(TimeUnitConfig config) {
        return config == TimeUnitConfig.MICROSECONDS || config == TimeUnitConfig.MILLISECONDS || config == TimeUnitConfig.CENTISECONDS || config == TimeUnitConfig.DECISECONDS;
    }

    static {
        UNIT_MAPPING.put("us", TimeUnitConfig.MICROSECONDS);
        UNIT_MAPPING.put("ms", TimeUnitConfig.MILLISECONDS);
        UNIT_MAPPING.put("cs", TimeUnitConfig.CENTISECONDS);
        UNIT_MAPPING.put("ds", TimeUnitConfig.DECISECONDS);
        UNIT_MAPPING.put("s", TimeUnitConfig.SECONDS);
        UNIT_MAPPING.put("sec", TimeUnitConfig.SECONDS);
        UNIT_MAPPING.put("second", TimeUnitConfig.SECONDS);
        UNIT_MAPPING.put("seconds", TimeUnitConfig.SECONDS);
        UNIT_MAPPING.put("m", TimeUnitConfig.MINUTES);
        UNIT_MAPPING.put("min", TimeUnitConfig.MINUTES);
        UNIT_MAPPING.put("minute", TimeUnitConfig.MINUTES);
        UNIT_MAPPING.put("minutes", TimeUnitConfig.MINUTES);
        UNIT_MAPPING.put("h", TimeUnitConfig.HOURS);
        UNIT_MAPPING.put("hr", TimeUnitConfig.HOURS);
        UNIT_MAPPING.put("hour", TimeUnitConfig.HOURS);
        UNIT_MAPPING.put("hours", TimeUnitConfig.HOURS);
        UNIT_MAPPING.put("d", TimeUnitConfig.DAYS);
        UNIT_MAPPING.put("day", TimeUnitConfig.DAYS);
        UNIT_MAPPING.put("days", TimeUnitConfig.DAYS);
        UNIT_MAPPING.put("M", TimeUnitConfig.MONTHS);
        UNIT_MAPPING.put("mon", TimeUnitConfig.MONTHS);
        UNIT_MAPPING.put("month", TimeUnitConfig.MONTHS);
        UNIT_MAPPING.put("months", TimeUnitConfig.MONTHS);
    }
}

