/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.parse;

import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.ExpressionEvaluationException;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.ExpressionNodeVisitor;
import org.opensearch.sql.expression.FunctionExpression;
import org.opensearch.sql.expression.env.Environment;
import org.opensearch.sql.expression.function.FunctionName;
import shaded.com.google.common.collect.ImmutableList;

public abstract class ParseExpression
extends FunctionExpression {
    protected final Expression sourceField;
    protected final Expression pattern;
    protected final Expression identifier;
    protected final String identifierStr;

    public ParseExpression(String functionName, Expression sourceField, Expression pattern, Expression identifier) {
        super(FunctionName.of(functionName), (List<Expression>)ImmutableList.of((Object)sourceField, (Object)pattern, (Object)identifier));
        this.sourceField = sourceField;
        this.pattern = pattern;
        this.identifier = identifier;
        this.identifierStr = identifier.valueOf().stringValue();
    }

    @Override
    public ExprValue valueOf(Environment<Expression, ExprValue> valueEnv) {
        ExprValue value = valueEnv.resolve(this.sourceField);
        if (value.isNull() || value.isMissing()) {
            return ExprValueUtils.nullValue();
        }
        try {
            return this.parseValue(value);
        }
        catch (ExpressionEvaluationException e) {
            throw new SemanticCheckException(String.format("failed to parse field \"%s\" with type [%s]", this.sourceField, value.type()));
        }
    }

    @Override
    public ExprType type() {
        return ExprCoreType.STRING;
    }

    @Override
    public <T, C> T accept(ExpressionNodeVisitor<T, C> visitor, C context) {
        return visitor.visitParse(this, context);
    }

    public abstract ExprValue parseValue(ExprValue var1) throws ExpressionEvaluationException;

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParseExpression)) {
            return false;
        }
        ParseExpression other = (ParseExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$sourceField = this.getSourceField();
        Expression other$sourceField = other.getSourceField();
        if (this$sourceField == null ? other$sourceField != null : !this$sourceField.equals(other$sourceField)) {
            return false;
        }
        Expression this$pattern = this.pattern;
        Expression other$pattern = other.pattern;
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Expression this$identifier = this.getIdentifier();
        Expression other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        String this$identifierStr = this.identifierStr;
        String other$identifierStr = other.identifierStr;
        return !(this$identifierStr == null ? other$identifierStr != null : !this$identifierStr.equals(other$identifierStr));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ParseExpression;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $sourceField = this.getSourceField();
        result = result * 59 + ($sourceField == null ? 43 : $sourceField.hashCode());
        Expression $pattern = this.pattern;
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Expression $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        String $identifierStr = this.identifierStr;
        result = result * 59 + ($identifierStr == null ? 43 : $identifierStr.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ParseExpression(sourceField=" + String.valueOf(this.getSourceField()) + ", pattern=" + String.valueOf(this.pattern) + ", identifier=" + String.valueOf(this.getIdentifier()) + ", identifierStr=" + this.identifierStr + ")";
    }

    @Generated
    public Expression getSourceField() {
        return this.sourceField;
    }

    @Generated
    public Expression getIdentifier() {
        return this.identifier;
    }
}

