/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Nullable;
import org.opensearch.common.geo.ShapeRelation;
import org.opensearch.common.network.InetAddresses;
import org.opensearch.common.time.DateFormatter;
import org.opensearch.common.time.DateMathParser;
import org.opensearch.common.unit.Fuzziness;
import org.opensearch.geometry.Geometry;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.DerivedField;
import org.opensearch.index.mapper.DerivedFieldSupportedTypes;
import org.opensearch.index.mapper.DerivedFieldValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoShapeQueryable;
import org.opensearch.index.mapper.IpFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperException;
import org.opensearch.index.mapper.TextFieldMapper;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.query.DerivedFieldQuery;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.script.AggregationScript;
import org.opensearch.script.DerivedFieldScript;
import org.opensearch.script.Script;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.lookup.LeafSearchLookup;
import org.opensearch.search.lookup.SearchLookup;

public class DerivedFieldType
extends MappedFieldType
implements GeoShapeQueryable {
    final DerivedField derivedField;
    final FieldMapper typeFieldMapper;
    final Function<Object, IndexableField> indexableFieldGenerator;

    @Override
    public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
        return this.typeFieldMapper.mappedFieldType.docValueFormat(format, timeZone);
    }

    public DerivedFieldType(DerivedField derivedField, boolean isIndexed, boolean isStored, boolean hasDocValues, Map<String, String> meta, FieldMapper typeFieldMapper, Function<Object, IndexableField> fieldFunction) {
        super(derivedField.getName(), isIndexed, isStored, hasDocValues, typeFieldMapper.fieldType().getTextSearchInfo(), meta);
        this.derivedField = derivedField;
        this.typeFieldMapper = typeFieldMapper;
        this.indexableFieldGenerator = fieldFunction;
    }

    public DerivedFieldType(DerivedField derivedField, FieldMapper typeFieldMapper, Function<Object, IndexableField> fieldFunction, IndexAnalyzers indexAnalyzers) {
        this(derivedField, false, false, false, Collections.emptyMap(), typeFieldMapper, fieldFunction);
    }

    @Override
    public TextSearchInfo getTextSearchInfo() {
        return this.typeFieldMapper.fieldType().getTextSearchInfo();
    }

    TextFieldMapper.TextFieldType getPrefilterFieldType(QueryShardContext context) {
        if (this.derivedField.getPrefilterField() == null || this.derivedField.getPrefilterField().isEmpty()) {
            return null;
        }
        MappedFieldType mappedFieldType = context.fieldMapper(this.derivedField.getPrefilterField());
        if (mappedFieldType == null) {
            throw new MapperException("prefilter_field[" + this.derivedField.getPrefilterField() + "] is not defined in the index mappings");
        }
        if (!(mappedFieldType.unwrap() instanceof TextFieldMapper.TextFieldType)) {
            throw new MapperException("prefilter_field[" + this.derivedField.getPrefilterField() + "] should be of type text. Type found [" + mappedFieldType.typeName() + "].");
        }
        return (TextFieldMapper.TextFieldType)mappedFieldType;
    }

    @Override
    public String typeName() {
        return "derived";
    }

    public String getType() {
        return this.derivedField.getType();
    }

    public FieldMapper getFieldMapper() {
        return this.typeFieldMapper;
    }

    public Function<Object, IndexableField> getIndexableFieldGenerator() {
        return this.indexableFieldGenerator;
    }

    public NamedAnalyzer getIndexAnalyzer() {
        return this.getFieldMapper().mappedFieldType.indexAnalyzer();
    }

    @Override
    public DerivedFieldValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't support formats.");
        }
        Function<Object, Object> valueForDisplay = DerivedFieldSupportedTypes.getValueForDisplayGenerator(this.getType(), this.derivedField.getFormat() != null ? DateFormatter.forPattern(this.derivedField.getFormat()) : null);
        return new DerivedFieldValueFetcher(DerivedFieldType.getDerivedFieldLeafFactory(this.derivedField.getScript(), context, searchLookup == null ? context.lookup() : searchLookup), valueForDisplay);
    }

    @Override
    public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        return this.getFieldMapper().mappedFieldType.fielddataBuilder(fullyQualifiedIndexName, searchLookup);
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.termQuery(value, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.termQuery(value, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query termQueryCaseInsensitive(Object value, @Nullable QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.termQueryCaseInsensitive(value, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.termQueryCaseInsensitive(value, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query termsQuery(List<?> values, @Nullable QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.termsQuery(values, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.termsQuery(values, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.rangeQuery(lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        return new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
    }

    @Override
    public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, method, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, method, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query prefixQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.prefixQuery(value, method, caseInsensitive, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.prefixQuery(value, method, caseInsensitive, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query wildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, boolean caseInsensitive, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.wildcardQuery(value, method, caseInsensitive, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.wildcardQuery(value, method, caseInsensitive, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query normalizedWildcardQuery(String value, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.normalizedWildcardQuery(value, method, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.normalizedWildcardQuery(value, method, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query regexpQuery(String value, int syntaxFlags, int matchFlags, int maxDeterminizedStates, @Nullable MultiTermQuery.RewriteMethod method, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> this.createConjuctionQuery(prefilterFieldType.regexpQuery(value, syntaxFlags, matchFlags, maxDeterminizedStates, method, context), derivedFieldQuery)).orElse(derivedFieldQuery);
    }

    @Override
    public Query phraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, QueryShardContext context) throws IOException {
        Query query = this.typeFieldMapper.mappedFieldType.phraseQuery(stream, slop, enablePositionIncrements, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> {
            try {
                return this.createConjuctionQuery(prefilterFieldType.phraseQuery(stream, slop, enablePositionIncrements, context), derivedFieldQuery);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(derivedFieldQuery);
    }

    @Override
    public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, QueryShardContext context) throws IOException {
        Query query = this.typeFieldMapper.mappedFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> {
            try {
                return this.createConjuctionQuery(prefilterFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, context), derivedFieldQuery);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(derivedFieldQuery);
    }

    @Override
    public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, QueryShardContext context) throws IOException {
        Query query = this.typeFieldMapper.mappedFieldType.phrasePrefixQuery(stream, slop, maxExpansions, context);
        DerivedFieldQuery derivedFieldQuery = new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
        return Optional.ofNullable(this.getPrefilterFieldType(context)).map(prefilterFieldType -> {
            try {
                return this.createConjuctionQuery(prefilterFieldType.phrasePrefixQuery(stream, slop, maxExpansions, context), derivedFieldQuery);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(derivedFieldQuery);
    }

    @Override
    public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
        throw new IllegalArgumentException("Can only use span prefix queries on text fields - not on [" + this.name() + "] which is of type [" + this.typeName() + "]");
    }

    @Override
    public Query distanceFeatureQuery(Object origin, String pivot, float boost, QueryShardContext context) {
        Query query = this.typeFieldMapper.mappedFieldType.distanceFeatureQuery(origin, pivot, boost, context);
        return new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
    }

    @Override
    public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, QueryShardContext context) {
        Query query = ((GeoShapeQueryable)((Object)this.typeFieldMapper.mappedFieldType)).geoShapeQuery(shape, fieldName, relation, context);
        return new DerivedFieldQuery(query, () -> this.valueFetcher(context, context.lookup(), null), context.lookup(), (Analyzer)this.getIndexAnalyzer(), this.indexableFieldGenerator, this.derivedField.getIgnoreMalformed());
    }

    @Override
    public Query existsQuery(QueryShardContext context) {
        throw new UnsupportedOperationException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support exist queries");
    }

    @Override
    public boolean isAggregatable() {
        return true;
    }

    private Query createConjuctionQuery(Query filterQuery, DerivedFieldQuery derivedFieldQuery) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(filterQuery, BooleanClause.Occur.FILTER);
        builder.add((Query)derivedFieldQuery, BooleanClause.Occur.FILTER);
        return builder.build();
    }

    public static DerivedFieldScript.LeafFactory getDerivedFieldLeafFactory(Script script, QueryShardContext context, SearchLookup searchLookup) {
        if (!context.documentMapper("").sourceMapper().enabled()) {
            throw new IllegalArgumentException("DerivedFieldQuery error: unable to fetch fields from _source field: _source is disabled in the mappings for index [" + context.index().getName() + "]");
        }
        DerivedFieldScript.Factory factory = context.compile(script, DerivedFieldScript.CONTEXT);
        return factory.newFactory(script.getParams(), searchLookup);
    }

    public AggregationScript.LeafFactory getAggregationScript(final QueryShardContext context) {
        return new AggregationScript.LeafFactory(){
            final /* synthetic */ DerivedFieldType this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public AggregationScript newInstance(final LeafReaderContext ctx) throws IOException {
                final DerivedFieldValueFetcher derivedFieldValueFetcher = this.this$0.valueFetcher(context, context.lookup(), null);
                derivedFieldValueFetcher.setNextReader(ctx);
                final LeafSearchLookup leafSearchLookup = context.lookup().getLeafSearchLookup(ctx);
                return new AggregationScript(this, this.this$0.derivedField.getScript().getParams(), context.lookup(), ctx){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        super(params, lookup, leafContext);
                    }

                    @Override
                    public Object execute() {
                        return this.this$1.this$0.formatValues(derivedFieldValueFetcher.fetchValuesInternal(leafSearchLookup.source()));
                    }

                    @Override
                    public void setDocument(int docid) {
                        super.setDocument(docid);
                        leafSearchLookup.source().setSegmentAndDocument(ctx, docid);
                    }
                };
            }

            @Override
            public boolean needs_score() {
                return false;
            }
        };
    }

    private Object formatValues(List<Object> objects) {
        if (this.typeFieldMapper instanceof IpFieldMapper) {
            return objects.stream().map(o -> (String)o).map(this::toBytesRef).collect(Collectors.toList());
        }
        return objects;
    }

    private BytesRef toBytesRef(String ip) {
        if (ip == null) {
            return null;
        }
        InetAddress address = InetAddresses.forString((String)ip);
        byte[] bytes = InetAddressPoint.encode((InetAddress)address);
        return new BytesRef(bytes);
    }
}

