/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.adjacency;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.InternalAggregations;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.BucketsAggregator;
import org.opensearch.search.aggregations.bucket.adjacency.InternalAdjacencyMatrix;
import org.opensearch.search.internal.SearchContext;

public class AdjacencyMatrixAggregator
extends BucketsAggregator {
    private final String[] keys;
    private final Weight[] filters;
    private final boolean showOnlyIntersecting;
    private final int totalNumKeys;
    private final int totalNumIntersections;
    private final String separator;

    public AdjacencyMatrixAggregator(String name, AggregatorFactories factories, String separator, String[] keys, Weight[] filters, boolean showOnlyIntersecting, SearchContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, CardinalityUpperBound.MANY, metadata);
        this.separator = separator;
        this.keys = keys;
        this.filters = filters;
        this.showOnlyIntersecting = showOnlyIntersecting;
        this.totalNumIntersections = (keys.length * keys.length - keys.length) / 2;
        this.totalNumKeys = keys.length + this.totalNumIntersections;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final Bits[] bits = new Bits[this.filters.length];
        for (int i = 0; i < this.filters.length; ++i) {
            bits[i] = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), this.filters[i].scorerSupplier(ctx));
        }
        return new LeafBucketCollectorBase(this, sub, null){
            final /* synthetic */ AdjacencyMatrixAggregator this$0;
            {
                this.this$0 = this$0;
                super(sub2, values);
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (!this.this$0.showOnlyIntersecting) {
                    for (int i = 0; i < bits.length; ++i) {
                        if (!bits[i].get(doc)) continue;
                        this.this$0.collectBucket(sub, doc, this.this$0.bucketOrd(bucket, i));
                    }
                }
                int pos = this.this$0.filters.length;
                for (int i = 0; i < this.this$0.filters.length; ++i) {
                    if (bits[i].get(doc)) {
                        for (int j = i + 1; j < this.this$0.filters.length; ++j) {
                            if (bits[j].get(doc)) {
                                this.this$0.collectBucket(sub, doc, this.this$0.bucketOrd(bucket, pos));
                            }
                            ++pos;
                        }
                        continue;
                    }
                    pos += this.this$0.filters.length - (i + 1);
                }
                assert (pos == bits.length + this.this$0.totalNumIntersections);
            }
        };
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        this.checkCancelled();
        int maxOrd = owningBucketOrds.length * this.totalNumKeys;
        int totalBucketsToBuild = 0;
        for (int ord = 0; ord < maxOrd; ++ord) {
            if (this.bucketDocCount(ord) <= 0L) continue;
            ++totalBucketsToBuild;
        }
        long[] bucketOrdsToBuild = new long[totalBucketsToBuild];
        int builtBucketIndex = 0;
        for (int ord = 0; ord < maxOrd; ++ord) {
            if (this.bucketDocCount(ord) <= 0L) continue;
            bucketOrdsToBuild[builtBucketIndex++] = ord;
        }
        assert (builtBucketIndex == totalBucketsToBuild);
        builtBucketIndex = 0;
        InternalAggregations[] bucketSubAggs = this.buildSubAggsForBuckets(bucketOrdsToBuild);
        InternalAggregation[] results = new InternalAggregation[owningBucketOrds.length];
        for (int owningBucketOrdIdx = 0; owningBucketOrdIdx < owningBucketOrds.length; ++owningBucketOrdIdx) {
            ArrayList<InternalAdjacencyMatrix.InternalBucket> buckets = new ArrayList<InternalAdjacencyMatrix.InternalBucket>(this.filters.length);
            for (int i = 0; i < this.keys.length; ++i) {
                long bucketOrd = this.bucketOrd(owningBucketOrds[owningBucketOrdIdx], i);
                long docCount = this.bucketDocCount(bucketOrd);
                if (docCount <= 0L) continue;
                InternalAdjacencyMatrix.InternalBucket bucket = new InternalAdjacencyMatrix.InternalBucket(this.keys[i], docCount, bucketSubAggs[builtBucketIndex++]);
                buckets.add(bucket);
            }
            int pos = this.keys.length;
            for (int i = 0; i < this.keys.length; ++i) {
                for (int j = i + 1; j < this.keys.length; ++j) {
                    long bucketOrd = this.bucketOrd(owningBucketOrds[owningBucketOrdIdx], pos);
                    long docCount = this.bucketDocCount(bucketOrd);
                    if (docCount > 0L) {
                        String intersectKey = this.keys[i] + this.separator + this.keys[j];
                        InternalAdjacencyMatrix.InternalBucket bucket = new InternalAdjacencyMatrix.InternalBucket(intersectKey, docCount, bucketSubAggs[builtBucketIndex++]);
                        buckets.add(bucket);
                    }
                    ++pos;
                }
            }
            results[owningBucketOrdIdx] = new InternalAdjacencyMatrix(this.name, buckets, this.metadata());
        }
        assert (builtBucketIndex == totalBucketsToBuild);
        return results;
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        ArrayList<InternalAdjacencyMatrix.InternalBucket> buckets = new ArrayList<InternalAdjacencyMatrix.InternalBucket>(0);
        return new InternalAdjacencyMatrix(this.name, buckets, this.metadata());
    }

    final long bucketOrd(long owningBucketOrdinal, int filterOrd) {
        return owningBucketOrdinal * (long)this.totalNumKeys + (long)filterOrd;
    }

    protected static class KeyedFilter
    implements Writeable,
    ToXContentFragment {
        private final String key;
        private final QueryBuilder filter;
        public static final ObjectParser.NamedObjectParser<KeyedFilter, String> PARSER = (p, aggName, name) -> new KeyedFilter(name, AbstractQueryBuilder.parseInnerQueryBuilder(p));

        public KeyedFilter(String key, QueryBuilder filter) {
            if (key == null) {
                throw new IllegalArgumentException("[key] must not be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("[filter] must not be null");
            }
            this.key = key;
            this.filter = filter;
        }

        public KeyedFilter(StreamInput in) throws IOException {
            this.key = in.readString();
            this.filter = (QueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeNamedWriteable((NamedWriteable)this.filter);
        }

        public String key() {
            return this.key;
        }

        public QueryBuilder filter() {
            return this.filter;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(this.key, (ToXContent)this.filter);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.filter);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyedFilter other = (KeyedFilter)obj;
            return Objects.equals(this.key, other.key) && Objects.equals(this.filter, other.filter);
        }
    }
}

