/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.model_group;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ExceptionsHelper;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.ml.common.exception.MLValidationException;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.model_group.MLModelGroupDeleteRequest;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.DeleteDataObjectResponse;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.client.SearchDataObjectRequest;
import org.opensearch.remote.metadata.client.SearchDataObjectResponse;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteModelGroupTransportAction
extends HandledTransportAction<ActionRequest, DeleteResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(DeleteModelGroupTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;
    private final ModelAccessControlHelper modelAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    @Inject
    public DeleteModelGroupTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ClusterService clusterService, ModelAccessControlHelper modelAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        super("cluster:admin/opensearch/ml/model_groups/delete", transportService, actionFilters, MLModelGroupDeleteRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        this.modelAccessControlHelper = modelAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<DeleteResponse> actionListener) {
        MLModelGroupDeleteRequest deleteRequest = MLModelGroupDeleteRequest.fromActionRequest((ActionRequest)request);
        String modelGroupId = deleteRequest.getModelGroupId();
        String tenantId = deleteRequest.getTenantId();
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, tenantId, actionListener)) {
            return;
        }
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(actionListener, () -> ((ThreadContext.StoredContext)context).restore());
            if (ModelAccessControlHelper.shouldUseResourceAuthz("ml-model-group")) {
                this.checkForAssociatedModels(modelGroupId, tenantId, (ActionListener<DeleteResponse>)wrappedListener);
            } else {
                this.validateAndDeleteModelGroup(modelGroupId, tenantId, (ActionListener<DeleteResponse>)wrappedListener);
            }
        }
    }

    private void validateAndDeleteModelGroup(String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        User user = RestActionUtils.getUserContext(this.client);
        this.modelAccessControlHelper.validateModelGroupAccess(user, this.mlFeatureEnabledSetting, tenantId, modelGroupId, "cluster:admin/opensearch/ml/model_groups/delete", this.client, this.sdkClient, (ActionListener<Boolean>)ActionListener.wrap(hasAccess -> this.handleAccessValidation((boolean)hasAccess, modelGroupId, tenantId, listener), error -> this.handleValidationError((Exception)error, modelGroupId, listener)));
    }

    private void handleAccessValidation(boolean hasAccess, String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        if (!hasAccess) {
            listener.onFailure((Exception)new MLValidationException("User doesn't have privilege to delete this model group"));
            return;
        }
        this.checkForAssociatedModels(modelGroupId, tenantId, listener);
    }

    private void checkForAssociatedModels(String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        SearchDataObjectRequest searchRequest = this.buildModelSearchRequest(modelGroupId, tenantId);
        this.sdkClient.searchDataObjectAsync(searchRequest).whenComplete((searchResponse, throwable) -> this.handleModelSearchResponse((SearchDataObjectResponse)searchResponse, (Throwable)throwable, modelGroupId, tenantId, listener));
    }

    private SearchDataObjectRequest buildModelSearchRequest(String modelGroupId, String tenantId) {
        BoolQueryBuilder query = new BoolQueryBuilder().filter((QueryBuilder)new TermQueryBuilder("model_group_id", modelGroupId));
        SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query);
        return SearchDataObjectRequest.builder().indices(new String[]{".plugins-ml-model"}).tenantId(tenantId).searchSourceBuilder(searchSource).build();
    }

    private void handleModelSearchResponse(SearchDataObjectResponse searchResponse, Throwable throwable, String modelGroupId, String tenantId, ActionListener<DeleteResponse> listener) {
        if (searchResponse == null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            this.handleModelSearchFailure(modelGroupId, tenantId, cause, listener);
            return;
        }
        try {
            SearchResponse response = searchResponse.searchResponse();
            if (response.getHits().getHits().length == 0) {
                DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-model-group", modelGroupId);
                this.deleteModelGroup(deleteRequest, tenantId, listener);
            } else {
                listener.onFailure((Exception)new OpenSearchStatusException("Cannot delete the model group when it has associated model versions", RestStatus.CONFLICT, new Object[0]));
            }
        }
        catch (Exception e) {
            log.error("Failed to parse search response", (Throwable)e);
            listener.onFailure((Exception)new OpenSearchStatusException("Failed to parse search response", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void deleteModelGroup(DeleteRequest deleteRequest, String tenantId, ActionListener<DeleteResponse> listener) {
        try {
            DeleteDataObjectRequest request = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(deleteRequest.index())).id(deleteRequest.id())).tenantId(tenantId)).build();
            this.sdkClient.deleteDataObjectAsync(request).whenComplete((response, throwable) -> this.handleDeleteResponse((DeleteDataObjectResponse)response, (Throwable)throwable, deleteRequest.id(), listener));
        }
        catch (Exception e) {
            log.error("Failed to delete Model group : {}", (Object)deleteRequest.id(), (Object)e);
            listener.onFailure(e);
        }
    }

    private void handleValidationError(Exception error, String modelGroupId, ActionListener<DeleteResponse> listener) {
        log.error("Failed to validate Access for Model Group {}", (Object)modelGroupId, (Object)error);
        listener.onFailure(error);
    }

    private void handleDeleteResponse(DeleteDataObjectResponse response, Throwable throwable, String modelGroupId, ActionListener<DeleteResponse> actionListener) {
        if (throwable != null) {
            Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
            log.error("Failed to delete ML Model Group {}", (Object)modelGroupId, (Object)cause);
            if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find model group", RestStatus.NOT_FOUND, new Object[0]));
                return;
            }
            actionListener.onFailure(cause);
        } else {
            try {
                DeleteResponse deleteResponse = response.deleteResponse();
                log.debug("Completed Delete Model Group Request, model group id:{} deleted", (Object)response.id());
                actionListener.onResponse((Object)deleteResponse);
            }
            catch (Exception e) {
                actionListener.onFailure(e);
            }
        }
    }

    private void handleModelSearchFailure(String modelGroupId, String tenantId, Exception cause, ActionListener<DeleteResponse> actionListener) {
        if (ExceptionsHelper.unwrap((Throwable)cause, (Class[])new Class[]{IndexNotFoundException.class}) != null) {
            DeleteRequest deleteRequest = new DeleteRequest(".plugins-ml-model-group", modelGroupId);
            this.deleteModelGroup(deleteRequest, tenantId, actionListener);
            return;
        }
        log.error("Failed to search for models using model group id: {}", (Object)modelGroupId, (Object)cause);
        actionListener.onFailure(cause);
    }
}

