/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.feature;

import java.io.IOException;
import java.time.Clock;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.feature.AbstractRetriever;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.Feature;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.transport.client.Client;

public class CompositeRetriever
extends AbstractRetriever {
    public static final String AGG_NAME_COMP = "comp_agg";
    private static final Logger LOG = LogManager.getLogger(CompositeRetriever.class);
    private final long dataStartEpoch;
    private final long dataEndEpoch;
    private final Config config;
    private final NamedXContentRegistry xContent;
    private final Client client;
    private final SecurityClientUtil clientUtil;
    private int totalResults;
    private int maxEntities;
    private final int pageSize;
    private long expirationEpochMs;
    private Clock clock;
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private ClusterService clusterService;
    private AnalysisType context;

    public CompositeRetriever(long dataStartEpoch, long dataEndEpoch, Config config, NamedXContentRegistry xContent, Client client, SecurityClientUtil clientUtil, long expirationEpochMs, Clock clock, Settings settings, int maxEntitiesPerInterval, int pageSize, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, AnalysisType context) {
        this.dataStartEpoch = dataStartEpoch;
        this.dataEndEpoch = dataEndEpoch;
        this.config = config;
        this.xContent = xContent;
        this.client = client;
        this.clientUtil = clientUtil;
        this.totalResults = 0;
        this.maxEntities = maxEntitiesPerInterval;
        this.pageSize = pageSize;
        this.expirationEpochMs = expirationEpochMs;
        this.clock = clock;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.clusterService = clusterService;
        this.context = context;
    }

    public CompositeRetriever(long dataStartEpoch, long dataEndEpoch, Config anomalyDetector, NamedXContentRegistry xContent, Client client, SecurityClientUtil clientUtil, long expirationEpochMs, Settings settings, int maxEntitiesPerInterval, int pageSize, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, AnalysisType context) {
        this(dataStartEpoch, dataEndEpoch, anomalyDetector, xContent, client, clientUtil, expirationEpochMs, Clock.systemUTC(), settings, maxEntitiesPerInterval, pageSize, indexNameExpressionResolver, clusterService, context);
    }

    public PageIterator iterator() throws IOException {
        RangeQueryBuilder rangeQuery = new RangeQueryBuilder(this.config.getTimeField()).gte((Object)this.dataStartEpoch).lt((Object)this.dataEndEpoch).format("epoch_millis");
        BoolQueryBuilder internalFilterQuery = new BoolQueryBuilder().filter(this.config.getFilterQuery()).filter((QueryBuilder)rangeQuery);
        CompositeAggregationBuilder composite = AggregationBuilders.composite((String)AGG_NAME_COMP, this.config.getCategoryFields().stream().map(f -> (TermsValuesSourceBuilder)new TermsValuesSourceBuilder(f).field(f)).collect(Collectors.toList())).size(this.pageSize);
        for (Feature feature : this.config.getFeatureAttributes()) {
            AggregatorFactories.Builder internalAgg = ParseUtils.parseAggregators(feature.getAggregation().toString(), this.xContent, feature.getId());
            composite.subAggregation((AggregationBuilder)internalAgg.getAggregatorFactories().iterator().next());
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)internalFilterQuery).size(0).aggregation((AggregationBuilder)composite).trackTotalHits(false);
        return new PageIterator(searchSourceBuilder);
    }

    public class PageIterator {
        private SearchSourceBuilder source;
        private Map<String, Object> afterKey;
        private int iterations;
        private long startMs;

        public PageIterator(SearchSourceBuilder source) {
            this.source = source;
            this.afterKey = null;
            this.iterations = 0;
            this.startMs = CompositeRetriever.this.clock.millis();
        }

        public void next(final ActionListener<Page> listener) {
            ++this.iterations;
            final SearchRequest searchRequest = new SearchRequest(CompositeRetriever.this.config.getIndices().toArray(new String[0]), this.source);
            ActionListener<SearchResponse> searchResponseListener = new ActionListener<SearchResponse>(){
                final /* synthetic */ PageIterator this$1;
                {
                    this.this$1 = this$1;
                }

                public void onResponse(SearchResponse response) {
                    this.this$1.processResponse(response, () -> this.this$1.CompositeRetriever.this.client.search(searchRequest, (ActionListener)this), (ActionListener<Page>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            };
            CompositeRetriever.this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)CompositeRetriever.this.client).search(arg_0, arg_1), CompositeRetriever.this.config.getId(), CompositeRetriever.this.client, CompositeRetriever.this.context, searchResponseListener);
        }

        private void processResponse(SearchResponse response, Runnable retry, ActionListener<Page> listener) {
            try {
                if (this.shouldRetryDueToEmptyPage(response)) {
                    this.updateCompositeAfterKey(response, this.source);
                    retry.run();
                    return;
                }
                Page page = this.analyzePage(response);
                if (this.afterKey != null) {
                    this.updateCompositeAfterKey(response, this.source);
                }
                listener.onResponse((Object)page);
            }
            catch (Exception ex) {
                listener.onFailure(ex);
            }
        }

        private Page analyzePage(SearchResponse response) {
            Optional<CompositeAggregation> compositeOptional = this.getComposite(response);
            if (!compositeOptional.isPresent()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Empty resposne: %s", response));
            }
            CompositeAggregation composite = compositeOptional.get();
            HashMap<Entity, double[]> results = new HashMap<Entity, double[]>();
            for (CompositeAggregation.Bucket bucket : composite.getBuckets()) {
                Optional<double[]> featureValues = CompositeRetriever.this.parseBucket((MultiBucketsAggregation.Bucket)bucket, CompositeRetriever.this.config.getEnabledFeatureIds(), true);
                if (!featureValues.isPresent() || bucket.getKey() == null) continue;
                results.put(Entity.createEntityByReordering(bucket.getKey()), featureValues.get());
            }
            CompositeRetriever.this.totalResults += results.size();
            this.afterKey = composite.afterKey();
            return new Page(CompositeRetriever.this, results);
        }

        private void updateCompositeAfterKey(SearchResponse r, SearchSourceBuilder search) {
            Optional<CompositeAggregation> composite = this.getComposite(r);
            if (!composite.isPresent()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Empty resposne: %s", r));
            }
            CompositeRetriever.this.updateSourceAfterKey(composite.get().afterKey(), search);
        }

        private boolean shouldRetryDueToEmptyPage(SearchResponse response) {
            Optional<CompositeAggregation> composite = this.getComposite(response);
            if (!composite.isPresent()) {
                return false;
            }
            CompositeAggregation aggr = composite.get();
            return aggr.getBuckets().isEmpty() && aggr.afterKey() != null && !aggr.afterKey().isEmpty();
        }

        Optional<CompositeAggregation> getComposite(SearchResponse response) {
            if (response == null || response.getAggregations() == null) {
                List<String> sourceIndices = CompositeRetriever.this.config.getIndices();
                String[] concreteIndices = CompositeRetriever.this.indexNameExpressionResolver.concreteIndexNames(CompositeRetriever.this.clusterService.state(), IndicesOptions.lenientExpandOpen(), sourceIndices.toArray(new String[0]));
                if (concreteIndices.length == 0) {
                    throw new IndexNotFoundException(String.join((CharSequence)",", sourceIndices));
                }
                return Optional.empty();
            }
            Aggregation agg = response.getAggregations().get(CompositeRetriever.AGG_NAME_COMP);
            if (agg == null) {
                return Optional.empty();
            }
            if (agg instanceof CompositeAggregation) {
                return Optional.of((CompositeAggregation)agg);
            }
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Not a composite response; {}", agg.getClass()));
        }

        public boolean hasNext() {
            long now = CompositeRetriever.this.clock.millis();
            if (CompositeRetriever.this.expirationEpochMs <= now) {
                LOG.debug((Message)new ParameterizedMessage("Time is up, afterKey: [{}], expirationEpochMs: [{}], now [{}]", new Object[]{this.afterKey, CompositeRetriever.this.expirationEpochMs, now}));
            }
            LOG.debug((Message)new ParameterizedMessage("Composite retriever state - iterations: [{}], afterKey: [{}], totalResults: [{}], maxEntities: [{}], expirationEpochMs: [{}], now: [{}]", new Object[]{this.iterations, this.afterKey, CompositeRetriever.this.totalResults, CompositeRetriever.this.maxEntities, CompositeRetriever.this.expirationEpochMs, now}));
            if (this.iterations > 0 && this.afterKey == null || CompositeRetriever.this.totalResults > CompositeRetriever.this.maxEntities) {
                LOG.debug((Message)new ParameterizedMessage("Finished in [{}] msecs. ", (Object)(now - this.startMs)));
            }
            return (this.iterations == 0 || CompositeRetriever.this.totalResults > 0 && this.afterKey != null) && CompositeRetriever.this.expirationEpochMs > now && CompositeRetriever.this.totalResults <= CompositeRetriever.this.maxEntities;
        }

        public String toString() {
            ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
            if (this.afterKey != null) {
                toStringBuilder.append("afterKey", this.afterKey);
            }
            if (this.source != null) {
                toStringBuilder.append("source", (Object)this.source);
            }
            return toStringBuilder.toString();
        }
    }

    public class Page {
        Map<Entity, double[]> results;

        public Page(CompositeRetriever this$0, Map<Entity, double[]> results) {
            this.results = results;
        }

        public boolean isEmpty() {
            return this.results == null || this.results.isEmpty();
        }

        public Map<Entity, double[]> getResults() {
            return this.results;
        }

        public String toString() {
            ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
            if (this.results != null) {
                toStringBuilder.append("results", this.results);
            }
            return toStringBuilder.toString();
        }
    }
}

