/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * cross(dvec3(-0.03lf, -0.85lf, -0.94lf), dvec3(-0.03lf, -0.85lf, -0.94lf)) => dvec3(0.0lf, 0.0lf, 0.0lf)
 * cross(dvec3(-0.03lf, -0.85lf, -0.94lf), dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf)) => dvec3(-0.9691000000000002lf, 1.3094333333333332lf, -1.1531333333333333lf)
 * cross(dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf), dvec3(-0.03lf, -0.85lf, -0.94lf)) => dvec3(0.9691000000000002lf, -1.3094333333333332lf, 1.1531333333333333lf)
 * cross(dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf), dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf)) => dvec3(0.0lf, 0.0lf, 0.0lf)
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(cross(dvec3(-0.03lf, -0.85lf, -0.94lf), dvec3(-0.03lf, -0.85lf, -0.94lf)), dvec3(0.0lf, 0.0lf, 0.0lf)) <= 1.607e-05lf ? 1 : -1] array0;
  double[distance(cross(dvec3(-0.03lf, -0.85lf, -0.94lf), dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf)), dvec3(-0.9691000000000002lf, 1.3094333333333332lf, -1.1531333333333333lf)) <= 3.029260039826375e-05lf ? 1 : -1] array1;
  double[distance(cross(dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf), dvec3(-0.03lf, -0.85lf, -0.94lf)), dvec3(0.9691000000000002lf, -1.3094333333333332lf, 1.1531333333333333lf)) <= 3.029260039826375e-05lf ? 1 : -1] array2;
  double[distance(cross(dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf), dvec3(-1.3333333333333333lf, 0.66lf, 1.87lf)), dvec3(0.0lf, 0.0lf, 0.0lf)) <= 5.710277777777779e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
