/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec3(-1333333333333333259l, 85l, 94l) + 0l) => i64vec3(-1333333333333333259l, 85l, 94l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + 3l) => i64vec3(-1333333333333333256l, 88l, 97l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + -1192l) => i64vec3(-1333333333333334451l, -1107l, -1098l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + 1048576l) => i64vec3(-1333333333332284683l, 1048661l, 1048670l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + 4251475l) => i64vec3(-1333333333329081784l, 4251560l, 4251569l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + 29852643761l) => i64vec3(-1333333303480689498l, 29852643846l, 29852643855l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + -4398046511104l) => i64vec3(-1333337731379844363l, -4398046511019l, -4398046511010l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + -3948976685146l) => i64vec3(-1333337282310018405l, -3948976685061l, -3948976685052l)
 * (i64vec3(-1333333333333333259l, 85l, 94l) + -135763469567146206l) => i64vec3(-1469096802900479465l, -135763469567146121l, -135763469567146112l)
 * (i64vec3(167l, 66l, 187l) + 0l) => i64vec3(167l, 66l, 187l)
 * (i64vec3(167l, 66l, 187l) + 3l) => i64vec3(170l, 69l, 190l)
 * (i64vec3(167l, 66l, 187l) + -1192l) => i64vec3(-1025l, -1126l, -1005l)
 * (i64vec3(167l, 66l, 187l) + 1048576l) => i64vec3(1048743l, 1048642l, 1048763l)
 * (i64vec3(167l, 66l, 187l) + 4251475l) => i64vec3(4251642l, 4251541l, 4251662l)
 * (i64vec3(167l, 66l, 187l) + 29852643761l) => i64vec3(29852643928l, 29852643827l, 29852643948l)
 * (i64vec3(167l, 66l, 187l) + -4398046511104l) => i64vec3(-4398046510937l, -4398046511038l, -4398046510917l)
 * (i64vec3(167l, 66l, 187l) + -3948976685146l) => i64vec3(-3948976684979l, -3948976685080l, -3948976684959l)
 * (i64vec3(167l, 66l, 187l) + -135763469567146206l) => i64vec3(-135763469567146039l, -135763469567146140l, -135763469567146019l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + 0l), i64vec3(-1333333333333333259l, 85l, 94l))) ? 1 : -1] array0;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + 3l), i64vec3(-1333333333333333256l, 88l, 97l))) ? 1 : -1] array1;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + -1192l), i64vec3(-1333333333333334451l, -1107l, -1098l))) ? 1 : -1] array2;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + 1048576l), i64vec3(-1333333333332284683l, 1048661l, 1048670l))) ? 1 : -1] array3;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + 4251475l), i64vec3(-1333333333329081784l, 4251560l, 4251569l))) ? 1 : -1] array4;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + 29852643761l), i64vec3(-1333333303480689498l, 29852643846l, 29852643855l))) ? 1 : -1] array5;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + -4398046511104l), i64vec3(-1333337731379844363l, -4398046511019l, -4398046511010l))) ? 1 : -1] array6;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + -3948976685146l), i64vec3(-1333337282310018405l, -3948976685061l, -3948976685052l))) ? 1 : -1] array7;
  float[all(equal((i64vec3(-1333333333333333259l, 85l, 94l) + -135763469567146206l), i64vec3(-1469096802900479465l, -135763469567146121l, -135763469567146112l))) ? 1 : -1] array8;
  float[all(equal((i64vec3(167l, 66l, 187l) + 0l), i64vec3(167l, 66l, 187l))) ? 1 : -1] array9;
  float[all(equal((i64vec3(167l, 66l, 187l) + 3l), i64vec3(170l, 69l, 190l))) ? 1 : -1] array10;
  float[all(equal((i64vec3(167l, 66l, 187l) + -1192l), i64vec3(-1025l, -1126l, -1005l))) ? 1 : -1] array11;
  float[all(equal((i64vec3(167l, 66l, 187l) + 1048576l), i64vec3(1048743l, 1048642l, 1048763l))) ? 1 : -1] array12;
  float[all(equal((i64vec3(167l, 66l, 187l) + 4251475l), i64vec3(4251642l, 4251541l, 4251662l))) ? 1 : -1] array13;
  float[all(equal((i64vec3(167l, 66l, 187l) + 29852643761l), i64vec3(29852643928l, 29852643827l, 29852643948l))) ? 1 : -1] array14;
  float[all(equal((i64vec3(167l, 66l, 187l) + -4398046511104l), i64vec3(-4398046510937l, -4398046511038l, -4398046510917l))) ? 1 : -1] array15;
  float[all(equal((i64vec3(167l, 66l, 187l) + -3948976685146l), i64vec3(-3948976684979l, -3948976685080l, -3948976684959l))) ? 1 : -1] array16;
  float[all(equal((i64vec3(167l, 66l, 187l) + -135763469567146206l), i64vec3(-135763469567146039l, -135763469567146140l, -135763469567146019l))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
