/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec2(-10l, -12l) << 0ul) => i64vec2(-10l, -12l)
 * (i64vec2(-10l, -12l) << 1ul) => i64vec2(-20l, -24l)
 * (i64vec2(-10l, -12l) << 2ul) => i64vec2(-40l, -48l)
 * (i64vec2(-10l, -12l) << 5ul) => i64vec2(-320l, -384l)
 * (i64vec2(-10l, -12l) << 25ul) => i64vec2(-335544320l, -402653184l)
 * (i64vec2(-10l, -12l) << 31ul) => i64vec2(-21474836480l, -25769803776l)
 * (i64vec2(-10l, -12l) << 32ul) => i64vec2(-42949672960l, -51539607552l)
 * (i64vec2(-10l, -12l) << 47ul) => i64vec2(-1407374883553280l, -1688849860263936l)
 * (i64vec2(-10l, -12l) << 63ul) => i64vec2(0l, 0l)
 * (i64vec2(-42l, 48l) << 0ul) => i64vec2(-42l, 48l)
 * (i64vec2(-42l, 48l) << 1ul) => i64vec2(-84l, 96l)
 * (i64vec2(-42l, 48l) << 2ul) => i64vec2(-168l, 192l)
 * (i64vec2(-42l, 48l) << 5ul) => i64vec2(-1344l, 1536l)
 * (i64vec2(-42l, 48l) << 25ul) => i64vec2(-1409286144l, 1610612736l)
 * (i64vec2(-42l, 48l) << 31ul) => i64vec2(-90194313216l, 103079215104l)
 * (i64vec2(-42l, 48l) << 32ul) => i64vec2(-180388626432l, 206158430208l)
 * (i64vec2(-42l, 48l) << 47ul) => i64vec2(-5910974510923776l, 6755399441055744l)
 * (i64vec2(-42l, 48l) << 63ul) => i64vec2(0l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec2(-10l, -12l) << 0ul), i64vec2(-10l, -12l))) ? 1 : -1] array0;
  float[all(equal((i64vec2(-10l, -12l) << 1ul), i64vec2(-20l, -24l))) ? 1 : -1] array1;
  float[all(equal((i64vec2(-10l, -12l) << 2ul), i64vec2(-40l, -48l))) ? 1 : -1] array2;
  float[all(equal((i64vec2(-10l, -12l) << 5ul), i64vec2(-320l, -384l))) ? 1 : -1] array3;
  float[all(equal((i64vec2(-10l, -12l) << 25ul), i64vec2(-335544320l, -402653184l))) ? 1 : -1] array4;
  float[all(equal((i64vec2(-10l, -12l) << 31ul), i64vec2(-21474836480l, -25769803776l))) ? 1 : -1] array5;
  float[all(equal((i64vec2(-10l, -12l) << 32ul), i64vec2(-42949672960l, -51539607552l))) ? 1 : -1] array6;
  float[all(equal((i64vec2(-10l, -12l) << 47ul), i64vec2(-1407374883553280l, -1688849860263936l))) ? 1 : -1] array7;
  float[all(equal((i64vec2(-10l, -12l) << 63ul), i64vec2(0l, 0l))) ? 1 : -1] array8;
  float[all(equal((i64vec2(-42l, 48l) << 0ul), i64vec2(-42l, 48l))) ? 1 : -1] array9;
  float[all(equal((i64vec2(-42l, 48l) << 1ul), i64vec2(-84l, 96l))) ? 1 : -1] array10;
  float[all(equal((i64vec2(-42l, 48l) << 2ul), i64vec2(-168l, 192l))) ? 1 : -1] array11;
  float[all(equal((i64vec2(-42l, 48l) << 5ul), i64vec2(-1344l, 1536l))) ? 1 : -1] array12;
  float[all(equal((i64vec2(-42l, 48l) << 25ul), i64vec2(-1409286144l, 1610612736l))) ? 1 : -1] array13;
  float[all(equal((i64vec2(-42l, 48l) << 31ul), i64vec2(-90194313216l, 103079215104l))) ? 1 : -1] array14;
  float[all(equal((i64vec2(-42l, 48l) << 32ul), i64vec2(-180388626432l, 206158430208l))) ? 1 : -1] array15;
  float[all(equal((i64vec2(-42l, 48l) << 47ul), i64vec2(-5910974510923776l, 6755399441055744l))) ? 1 : -1] array16;
  float[all(equal((i64vec2(-42l, 48l) << 63ul), i64vec2(0l, 0l))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
