/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * cos(-3.1415927) => -1.0
 * cos(-1.0471976) => 0.49999997
 * cos(1.0471976) => 0.49999997
 * cos(3.1415927) => -1.0
 */
#version 120

void main()
{
  float[distance(cos(-3.1415927), -1.0) <= 0.001 ? 1 : -1] array0;
  float[distance(cos(-1.0471976), 0.49999997) <= 0.00049999997 ? 1 : -1] array1;
  float[distance(cos(1.0471976), 0.49999997) <= 0.00049999997 ? 1 : -1] array2;
  float[distance(cos(3.1415927), -1.0) <= 0.001 ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
